/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.subversion;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.CredentialsSVNAuthenticationProviderImpl;
import hudson.scm.FilterSVNAuthenticationManager;
import hudson.scm.SVNAuthStoreHandlerImpl;
import hudson.scm.SVNAuthenticationManager;
import hudson.util.TimeUnit2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNRepositoryView {
    public static final int DIRENTS = 25;
    private static final Logger LOGGER = Logger.getLogger(SVNRepositoryView.class.getName());
    private final DB cache;
    private final SVNRepository repository;
    private final ConcurrentMap<String, NodeEntry> data;
    private final String uuid;

    public SVNRepositoryView(SVNURL repoURL, StandardCredentials credentials) throws SVNException, IOException {
        this.repository = SVNRepositoryFactory.create((SVNURL)repoURL);
        File configDir = SVNWCUtil.getDefaultConfigurationDirectory();
        Object sam = new SVNAuthenticationManager(configDir, null, null);
        sam.setAuthenticationProvider(new CredentialsSVNAuthenticationProviderImpl((Credentials)credentials));
        SVNAuthStoreHandlerImpl.install((ISVNAuthenticationManager)sam);
        sam = new FilterSVNAuthenticationManager((ISVNAuthenticationManager)sam){

            @Override
            public int getReadTimeout(SVNRepository repository) {
                int r = super.getReadTimeout(repository);
                if (r <= 0) {
                    r = (int)TimeUnit2.MINUTES.toMillis(1L);
                }
                return r;
            }
        };
        this.repository.setTunnelProvider((ISVNTunnelProvider)SVNWCUtil.createDefaultOptions((boolean)true));
        this.repository.setAuthenticationManager((ISVNAuthenticationManager)sam);
        try {
            this.uuid = this.repository.getRepositoryUUID(true);
            if (this.uuid == null) {
                throw new IOException("Could not find UUID for " + repoURL);
            }
            Jenkins instance = Jenkins.getInstance();
            File cacheFile = instance != null ? new File(new File(instance.getRootDir(), "caches"), "svn-" + this.uuid + ".db") : new File(new File(FileUtils.getTempDirectory(), "caches"), "svn-" + this.uuid + ".db");
            cacheFile.getParentFile().mkdirs();
            DB cache = null;
            int count = 0;
            while (cache == null) {
                try {
                    cache = DBMaker.newFileDB((File)cacheFile).cacheWeakRefEnable().make();
                }
                catch (Throwable t) {
                    cacheFile.delete();
                    LOGGER.log(Level.WARNING, "failing to make/load " + cacheFile, t);
                    if (++count < 10) continue;
                    throw new IOException("failed to make/load " + cacheFile + ": " + t, t);
                }
            }
            this.cache = cache;
            this.data = this.cache.getHashMap(credentials == null ? "data" : "data-" + credentials.getId());
            cache.commit();
        }
        catch (SVNException e) {
            this.repository.closeSession();
            throw e;
        }
        catch (IOException e) {
            this.repository.closeSession();
            throw e;
        }
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    @NonNull
    public String getUuid() {
        return this.uuid;
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.repository.closeSession();
        this.cache.close();
    }

    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        NodeEntry nodeEntry;
        block5: {
            nodeEntry = this.getNodeEntry(path = SVNPathUtil.getAbsolutePath((String)path));
            if (nodeEntry == null || nodeEntry.getRevision() != revision) {
                try {
                    SVNNodeKind svnNodeKind = this.repository.checkPath(path, revision);
                    if (SVNNodeKind.DIR.equals(svnNodeKind)) {
                        ChildEntryCollector collector = new ChildEntryCollector();
                        long dirRev = this.repository.getDir(path, revision, null, 25, (ISVNDirEntryHandler)collector);
                        nodeEntry = new NodeEntry(dirRev, svnNodeKind, collector.getResult());
                    } else {
                        nodeEntry = new NodeEntry(revision, svnNodeKind, null);
                    }
                    this.setNodeEntry(path, nodeEntry);
                }
                catch (SVNException e) {
                    if (nodeEntry != null) break block5;
                    throw e;
                }
            }
        }
        return nodeEntry.getType();
    }

    @CheckForNull
    private NodeEntry getNodeEntry(String path) {
        try {
            return (NodeEntry)this.data.get(path);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void setNodeEntry(String path, NodeEntry nodeEntry) {
        try {
            this.data.put(path, nodeEntry);
            this.cache.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getLatestRevision() throws SVNException {
        return this.repository.getLatestRevision();
    }

    public NodeEntry getNode(String path, long revision) throws SVNException {
        NodeEntry nodeEntry;
        block11: {
            nodeEntry = this.getNodeEntry(path = SVNPathUtil.getAbsolutePath((String)path));
            if (nodeEntry == null || nodeEntry.getRevision() != revision) {
                try {
                    SVNNodeKind svnNodeKind = this.repository.checkPath(path, revision);
                    if (revision == -1L) {
                        if (SVNNodeKind.DIR.equals(svnNodeKind)) {
                            ChildEntryCollector collector = new ChildEntryCollector();
                            long dirRev = this.repository.getDir(path, revision, null, 25, (ISVNDirEntryHandler)collector);
                            nodeEntry = new NodeEntry(dirRev, svnNodeKind, collector.getResult());
                        } else if (SVNNodeKind.FILE.equals(svnNodeKind)) {
                            long fileRev = this.repository.getFile(path, revision, null, null);
                            nodeEntry = new NodeEntry(fileRev, svnNodeKind, null);
                        } else {
                            nodeEntry = new NodeEntry(revision, svnNodeKind, null);
                        }
                    } else {
                        nodeEntry = new NodeEntry(revision, svnNodeKind, null);
                    }
                    if (!nodeEntry.getType().equals(SVNNodeKind.DIR)) {
                        this.setNodeEntry(path, nodeEntry);
                    }
                }
                catch (SVNException e) {
                    if (nodeEntry != null) break block11;
                    throw e;
                }
            }
        }
        if (nodeEntry.getType().equals(SVNNodeKind.DIR) && nodeEntry.getChildren() == null) {
            ChildEntryCollector collector = new ChildEntryCollector();
            long dirRev = this.repository.getDir(path, revision, null, 25, (ISVNDirEntryHandler)collector);
            nodeEntry = new NodeEntry(dirRev, nodeEntry.getType(), collector.getResult());
            this.setNodeEntry(path, nodeEntry);
        }
        return nodeEntry;
    }

    private static class ChildEntryCollector
    implements ISVNDirEntryHandler {
        private final List<ChildEntry> children = new ArrayList<ChildEntry>();

        private ChildEntryCollector() {
        }

        public void handleDirEntry(SVNDirEntry entry) throws SVNException {
            this.children.add(new ChildEntry(entry.getRevision(), entry.getDate().getTime(), entry.getKind(), entry.getName()));
        }

        public ChildEntry[] getResult() {
            return this.children.toArray(new ChildEntry[this.children.size()]);
        }
    }

    public static class ChildEntry
    implements Serializable {
        private final long revision;
        private final SVNNodeKind type;
        private final String name;
        private final long lastModified;

        public ChildEntry(long revision, long lastModified, SVNNodeKind type, String name) {
            this.revision = revision;
            this.type = type;
            this.name = name;
            this.lastModified = lastModified;
        }

        public SVNNodeKind getType() {
            return this.type;
        }

        public long getRevision() {
            return this.revision;
        }

        public String getName() {
            return this.name;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }

    public static class NodeEntry
    implements Serializable {
        private final long revision;
        private final SVNNodeKind type;
        private final ChildEntry[] children;

        public NodeEntry(long revision, SVNNodeKind type, ChildEntry[] children) {
            this.revision = revision;
            this.type = type;
            this.children = children;
        }

        public SVNNodeKind getType() {
            return this.type;
        }

        public long getRevision() {
            return this.revision;
        }

        public ChildEntry[] getChildren() {
            return this.children;
        }
    }
}

