/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.Extension;
import hudson.Util;
import hudson.scm.SubversionSCM;
import hudson.scm.SubversionWorkspaceSelector;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.SubversionUpdateEventHandler;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.time.FastDateFormat;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CheckoutUpdater
extends WorkspaceUpdater {
    private static final long serialVersionUID = -3502075714024708011L;
    private static final FastDateFormat fmt = FastDateFormat.getInstance((String)"''yyyy-MM-dd'T'HH:mm:ss.SSS Z''");

    @DataBoundConstructor
    public CheckoutUpdater() {
    }

    @Override
    public WorkspaceUpdater.UpdateTask createTask() {
        return new WorkspaceUpdater.UpdateTask(){
            private static final long serialVersionUID = 8349986526712487762L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubversionSCM.External> perform() throws IOException, InterruptedException {
                SVNUpdateClient svnuc = this.clientManager.getUpdateClient();
                ArrayList<SubversionSCM.External> externals = new ArrayList<SubversionSCM.External>();
                this.listener.getLogger().println("Cleaning local Directory " + this.location.getLocalDir());
                Util.deleteContentsRecursive((File)new File(this.ws, this.location.getLocalDir()));
                PipedOutputStream pos = new PipedOutputStream();
                StreamCopyThread sct = new StreamCopyThread("svn log copier", (InputStream)new PipedInputStream(pos), (OutputStream)this.listener.getLogger());
                sct.start();
                try {
                    SVNRevision r = this.getRevision(this.location);
                    String revisionName = r.getDate() != null ? fmt.format(r.getDate()) : r.toString();
                    this.listener.getLogger().println("Checking out " + this.location.getSVNURL().toString() + " at revision " + revisionName);
                    File local = new File(this.ws, this.location.getLocalDir());
                    SubversionUpdateEventHandler eventHandler = new SubversionUpdateEventHandler(new PrintStream(pos), externals, local, this.location.getLocalDir());
                    svnuc.setEventHandler((ISVNEventHandler)eventHandler);
                    svnuc.setExternalsHandler((ISVNExternalsHandler)eventHandler);
                    svnuc.setIgnoreExternals(this.location.isIgnoreExternalsOption());
                    SVNDepth svnDepth = 1.getSvnDepth(this.location.getDepthOption());
                    SvnCheckout checkout = svnuc.getOperationsFactory().createCheckout();
                    checkout.setSource(SvnTarget.fromURL((SVNURL)this.location.getSVNURL(), (SVNRevision)SVNRevision.HEAD));
                    checkout.setSingleTarget(SvnTarget.fromFile((File)local.getCanonicalFile()));
                    checkout.setDepth(svnDepth);
                    checkout.setRevision(r);
                    checkout.setAllowUnversionedObstructions(true);
                    checkout.setIgnoreExternals(this.location.isIgnoreExternalsOption());
                    checkout.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)svnuc.getExternalsHandler()));
                    if (SubversionWorkspaceSelector.workspaceFormat == 100) {
                        SubversionWorkspaceSelector.workspaceFormat = 29;
                    }
                    checkout.setTargetWorkingCopyFormat(SubversionWorkspaceSelector.workspaceFormat);
                    checkout.run();
                }
                catch (SVNCancelException e) {
                    if (WorkspaceUpdater.isAuthenticationFailedError(e)) {
                        e.printStackTrace(this.listener.error("Failed to check out " + this.location.remote));
                        List<SubversionSCM.External> list = null;
                        return list;
                    }
                    this.listener.error("Subversion checkout has been canceled");
                    throw (InterruptedException)new InterruptedException().initCause(e);
                }
                catch (SVNException e) {
                    e.printStackTrace(this.listener.error("Failed to check out " + this.location.remote));
                    throw new IOException("Failed to check out " + this.location.remote, e);
                }
                finally {
                    try {
                        pos.close();
                    }
                    finally {
                        try {
                            sct.join();
                        }
                        catch (InterruptedException e) {
                            throw new IOException2("interrupted", (Throwable)e);
                        }
                    }
                }
                return externals;
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends WorkspaceUpdaterDescriptor {
        public String getDisplayName() {
            return Messages.CheckoutUpdater_DisplayName();
        }
    }
}

