/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.triggers.SCMTriggerItem;

@Extension
public class SCMTriggerListener
extends SCMEventListener {
    private static final Logger LOGGER = Logger.getLogger(SCMTriggerListener.class.getName());

    @Override
    public void onSCMHeadEvent(SCMHeadEvent<?> event) {
        switch (event.getType()) {
            case CREATED: 
            case UPDATED: {
                block3: for (Item project : Jenkins.getActiveInstance().getAllItems()) {
                    SCMTrigger trigger;
                    SCMTriggerItem scmTriggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)project);
                    if (scmTriggerItem == null || (trigger = scmTriggerItem.getSCMTrigger()) == null || trigger.isIgnorePostCommitHooks()) continue;
                    for (SCM scm : scmTriggerItem.getSCMs()) {
                        Action[] actionArray;
                        if (!event.isMatch(scm)) continue;
                        LOGGER.log(Level.INFO, "Triggering polling of {0}", project.getFullName());
                        Cause[] causes = event.asCauses();
                        if (causes.length == 0) {
                            actionArray = null;
                        } else {
                            Action[] actionArray2 = new Action[1];
                            actionArray = actionArray2;
                            actionArray2[0] = new CauseAction(causes);
                        }
                        trigger.run(actionArray);
                        continue block3;
                    }
                }
                break;
            }
        }
    }
}

