/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.stash;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class UnstashStep
extends AbstractStepImpl {
    @Nonnull
    private final String name;

    @DataBoundConstructor
    public UnstashStep(@Nonnull String name) {
        Jenkins.checkGoodName((String)name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "unstash";
        }

        public String getDisplayName() {
            return "Restore files previously stashed";
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient UnstashStep step;
        @StepContextParameter
        private transient Run<?, ?> build;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient TaskListener listener;

        protected Void run() throws Exception {
            StashManager.unstash(this.build, (String)this.step.name, (FilePath)this.workspace, (TaskListener)this.listener);
            return null;
        }
    }
}

