/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.stash;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class StashStep
extends AbstractStepImpl {
    @Nonnull
    private final String name;
    @CheckForNull
    private String includes;
    @CheckForNull
    private String excludes;
    private boolean useDefaultExcludes = true;

    @DataBoundConstructor
    public StashStep(@Nonnull String name) {
        Jenkins.checkGoodName((String)name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getIncludes() {
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = Util.fixEmpty((String)includes);
    }

    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = Util.fixEmpty((String)excludes);
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    @DataBoundSetter
    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "stash";
        }

        public String getDisplayName() {
            return "Stash some files to be used later in the build";
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient StashStep step;
        @StepContextParameter
        private transient Run<?, ?> build;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient TaskListener listener;

        protected Void run() throws Exception {
            StashManager.stash(this.build, (String)this.step.name, (FilePath)this.workspace, (TaskListener)this.listener, (String)this.step.includes, (String)this.step.excludes, (boolean)this.step.useDefaultExcludes);
            return null;
        }
    }
}

