/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class WriteFileStep
extends AbstractStepImpl {
    private final String file;
    private final String text;
    private String encoding;

    @DataBoundConstructor
    public WriteFileStep(String file, String text) {
        this.file = file;
        this.text = text;
    }

    public String getFile() {
        return this.file;
    }

    public String getText() {
        return this.text;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = Util.fixEmptyAndTrim((String)encoding);
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        @Inject
        private transient WriteFileStep step;
        @StepContextParameter
        private transient FilePath workspace;
        private static final long serialVersionUID = 1L;

        protected Void run() throws Exception {
            this.workspace.child(this.step.file).write(this.step.text, null);
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "writeFile";
        }

        public String getDisplayName() {
            return "Write file to workspace";
        }
    }
}

