/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.ListBoxModel;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class ToolStep
extends AbstractStepImpl {
    private final String name;
    @CheckForNull
    private String type;

    @DataBoundConstructor
    public ToolStep(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @DataBoundSetter
    public void setType(String type) {
        this.type = Util.fixEmpty((String)type);
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<String> {
        @Inject
        private transient ToolStep step;
        @StepContextParameter
        transient TaskListener listener;
        @StepContextParameter
        transient EnvVars env;
        @StepContextParameter
        transient Node node;
        private static final long serialVersionUID = 1L;

        protected String run() throws Exception {
            String name = this.step.getName();
            String type = this.step.getType();
            for (ToolDescriptor desc : ToolInstallation.all()) {
                if (type != null && !desc.getId().equals(type) && !SymbolLookup.getSymbolValue((Object)desc).contains(type)) continue;
                for (ToolInstallation tool : desc.getInstallations()) {
                    if (!tool.getName().equals(name)) continue;
                    if (tool instanceof NodeSpecific) {
                        tool = (ToolInstallation)((NodeSpecific)tool).forNode(this.node, this.listener);
                    }
                    if (tool instanceof EnvironmentSpecific) {
                        tool = (ToolInstallation)((EnvironmentSpecific)tool).forEnvironment(this.env);
                    }
                    return tool.getHome();
                }
            }
            throw new AbortException("No " + (type != null ? type : "tool") + " named " + name + " found");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "tool";
        }

        public String getDisplayName() {
            return "Use a tool from a predefined Tool Installation";
        }

        public ListBoxModel doFillTypeItems() {
            ListBoxModel r = new ListBoxModel();
            r.add("<any>", "");
            for (ToolDescriptor desc : ToolInstallation.all()) {
                String idOrSymbol = desc.getId();
                Set symbols = SymbolLookup.getSymbolValue((Object)desc);
                if (!symbols.isEmpty()) {
                    idOrSymbol = (String)symbols.iterator().next();
                }
                r.add(desc.getDisplayName(), idOrSymbol);
            }
            return r;
        }

        public ListBoxModel doFillNameItems(@QueryParameter String type) {
            type = Util.fixEmpty((String)type);
            ListBoxModel r = new ListBoxModel();
            for (ToolDescriptor desc : ToolInstallation.all()) {
                if (type != null && !desc.getId().equals(type) && !SymbolLookup.getSymbolValue((Object)desc).contains(type)) continue;
                for (ToolInstallation tool : desc.getInstallations()) {
                    r.add(tool.getName());
                }
            }
            return r;
        }
    }
}

