/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.Extension;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.TimeoutStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TimeoutStep
extends AbstractStepImpl
implements Serializable {
    private final int time;
    private TimeUnit unit = TimeUnit.MINUTES;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public TimeoutStep(int time) {
        this.time = time;
    }

    @DataBoundSetter
    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public int getTime() {
        return this.time;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(TimeoutStepExecution.class);
        }

        public String getFunctionName() {
            return "timeout";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getDisplayName() {
            return "Enforce time limit";
        }

        public ListBoxModel doFillUnitItems() {
            ListBoxModel r = new ListBoxModel();
            for (TimeUnit unit : TimeUnit.values()) {
                r.add(unit.name());
            }
            return r;
        }
    }
}

