/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.slaves.WorkspaceList;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PwdStep
extends AbstractStepImpl {
    private boolean tmp;

    @DataBoundConstructor
    public PwdStep() {
    }

    public boolean isTmp() {
        return this.tmp;
    }

    @DataBoundSetter
    public void setTmp(boolean tmp) {
        this.tmp = tmp;
    }

    private static FilePath tempDir(FilePath ws) {
        return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<String> {
        @StepContextParameter
        private transient FilePath cwd;
        @Inject(optional=true)
        private transient PwdStep step;
        private static final long serialVersionUID = 1L;

        protected String run() throws Exception {
            return (this.step.isTmp() ? PwdStep.tempDir(this.cwd) : this.cwd).getRemote();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "pwd";
        }

        public String getDisplayName() {
            return "Determine current directory";
        }
    }
}

