/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.Extension;
import hudson.model.TaskListener;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class EchoStep
extends AbstractStepImpl {
    private final String message;

    @DataBoundConstructor
    public EchoStep(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        @Inject
        private transient EchoStep step;
        @StepContextParameter
        private transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        protected Void run() throws Exception {
            this.listener.getLogger().println(this.step.getMessage());
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "echo";
        }

        public String getDisplayName() {
            return "Print Message";
        }
    }
}

