/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public final class CoreStep
extends AbstractStepImpl {
    public final SimpleBuildStep delegate;

    @DataBoundConstructor
    public CoreStep(SimpleBuildStep delegate) {
        this.delegate = delegate;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "step";
        }

        public String getDisplayName() {
            return "General Build Step";
        }

        public boolean isMetaStep() {
            return true;
        }

        public Collection<? extends Descriptor<?>> getApplicableDescriptors() {
            ArrayList r = new ArrayList();
            this.populate(r, Builder.class);
            this.populate(r, Publisher.class);
            return r;
        }

        private <T extends Describable<T>, D extends Descriptor<T>> void populate(List<Descriptor<?>> r, Class<T> c) {
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                return;
            }
            for (Descriptor d : j.getDescriptorList(c)) {
                if (!SimpleBuildStep.class.isAssignableFrom(d.clazz)) continue;
                r.add(d);
            }
        }
    }

    private static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        @Inject
        private transient CoreStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        private Execution() {
        }

        protected Void run() throws Exception {
            this.workspace.mkdirs();
            this.step.delegate.perform(this.run, this.workspace, this.launcher, this.listener);
            return null;
        }

        public String getStatus() {
            String supe = super.getStatus();
            return this.step != null ? this.step.delegate.getClass().getName() + ": " + supe : supe;
        }
    }
}

