/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.ArtifactManager;
import jenkins.util.VirtualFile;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.ArtifactUnarchiverStep;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class ArtifactUnarchiverStepExecution
extends AbstractSynchronousNonBlockingStepExecution<List<FilePath>> {
    @StepContextParameter
    private transient FilePath ws;
    @StepContextParameter
    private transient Run build;
    @Inject
    private transient ArtifactUnarchiverStep step;
    private static final long serialVersionUID = 1L;

    protected List<FilePath> run() throws Exception {
        Run r = this.build;
        ArtifactManager am = r.getArtifactManager();
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        if (this.step.mapping == null) {
            throw new AbortException("'mapping' has not been defined for this 'unarchive' step");
        }
        for (Map.Entry<String, String> e : this.step.mapping.entrySet()) {
            FilePath dst = new FilePath(this.ws, e.getValue());
            String src = e.getKey();
            String[] all = am.root().list(src);
            if (all.length == 0) {
                throw new AbortException("no artifacts to unarchive in " + src);
            }
            if (all.length == 1 && all[0].equals(src)) {
                if (dst.isDirectory()) {
                    dst = dst.child(this.getFileName(all[0]));
                }
                files.add(this.copy(am.root().child(all[0]), dst));
                continue;
            }
            for (String path : all) {
                files.add(this.copy(am.root().child(path), dst.child(path)));
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilePath copy(VirtualFile src, FilePath dst) throws IOException, InterruptedException {
        try (InputStream in = src.open();){
            dst.copyFrom(in);
        }
        return dst;
    }

    private String getFileName(String s) {
        int idx = s.lastIndexOf(47);
        if (idx >= 0) {
            s = s.substring(idx + 1);
        }
        if ((idx = s.lastIndexOf(92)) >= 0) {
            s = s.substring(idx + 1);
        }
        return s;
    }
}

