/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Checksum;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;

public class InitializeJarCacheMain {
    private static final FilenameFilter JAR_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            throw new IllegalArgumentException("Usage: java -cp slave.jar hudson.remoting.InitializeJarCacheMain <source jar dir> <jar cache dir>");
        }
        File sourceJarDir = new File(argv[0]);
        File jarCacheDir = new File(argv[1]);
        FileSystemJarCache jarCache = new FileSystemJarCache(jarCacheDir, false);
        File[] jars = sourceJarDir.listFiles(JAR_FILE_FILTER);
        if (jars == null) {
            throw new IOException("Cannot list JAR files in " + sourceJarDir);
        }
        for (File jar : jars) {
            Checksum checksum = Checksum.forFile(jar);
            File newJarLocation = jarCache.map(checksum.sum1, checksum.sum2);
            Util.mkdirs(newJarLocation.getParentFile());
            InitializeJarCacheMain.copyFile(jar, newJarLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File src, File dest) throws Exception {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(src);
            output = new FileOutputStream(dest);
            byte[] buf = new byte[0x100000];
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }
}

