/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro;

import com.google.common.collect.ListMultimap;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.Messages;
import org.jenkinsci.plugins.tokenmacro.Parser;

public abstract class TokenMacro
implements ExtensionPoint {
    public abstract boolean acceptsMacroName(String var1);

    public abstract String evaluate(AbstractBuild<?, ?> var1, TaskListener var2, String var3, Map<String, String> var4, ListMultimap<String, String> var5) throws MacroEvaluationException, IOException, InterruptedException;

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) throws MacroEvaluationException, IOException, InterruptedException {
        return macroName + " is not supported in this context";
    }

    public boolean hasNestedContent() {
        return false;
    }

    public List<String> getAcceptedMacroNames() {
        return Collections.EMPTY_LIST;
    }

    public static List<String> getAutoCompleteList(String input) {
        ArrayList<String> result = new ArrayList<String>();
        for (TokenMacro m : TokenMacro.all()) {
            for (String name : m.getAcceptedMacroNames()) {
                if (name.isEmpty() || !name.startsWith(input)) continue;
                result.add(name);
            }
        }
        return result;
    }

    public static ExtensionList<TokenMacro> all() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            return jenkins.getExtensionList(TokenMacro.class);
        }
        return ExtensionList.create((Jenkins)null, TokenMacro.class);
    }

    public static String expand(AbstractBuild<?, ?> context, TaskListener listener, String stringWithMacro) throws MacroEvaluationException, IOException, InterruptedException {
        return TokenMacro.expand(context, listener, stringWithMacro, true, null);
    }

    public static String expand(AbstractBuild<?, ?> context, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException, IOException, InterruptedException {
        return Parser.process(context, listener, stringWithMacro, throwException, privateTokens);
    }

    public static String expand(Run<?, ?> run, FilePath workspace, TaskListener listener, String stringWithMacro) throws MacroEvaluationException, IOException, InterruptedException {
        return TokenMacro.expand(run, workspace, listener, stringWithMacro, true, null);
    }

    public static String expand(Run<?, ?> run, FilePath workspace, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException, IOException, InterruptedException {
        return Parser.process(run, workspace, listener, stringWithMacro, throwException, privateTokens);
    }

    public static String expandAll(AbstractBuild<?, ?> context, TaskListener listener, String stringWithMacro) throws MacroEvaluationException, IOException, InterruptedException {
        return TokenMacro.expandAll(context, listener, stringWithMacro, true, null);
    }

    public static String expandAll(Run<?, ?> run, FilePath workspace, TaskListener listener, String stringWithMacro) throws MacroEvaluationException, IOException, InterruptedException {
        return TokenMacro.expandAll(run, workspace, listener, stringWithMacro, true, null);
    }

    public static String expandAll(AbstractBuild<?, ?> context, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException, IOException, InterruptedException {
        return TokenMacro.expandAll(context, TokenMacro.getWorkspace(context), listener, stringWithMacro, throwException, privateTokens);
    }

    public static String expandAll(Run<?, ?> run, FilePath workspace, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException, IOException, InterruptedException {
        if (stringWithMacro == null || stringWithMacro.length() == 0) {
            return stringWithMacro;
        }
        stringWithMacro = stringWithMacro.replaceAll("\\$\\$", "\\$\\$\\$\\$");
        String s = run.getEnvironment(listener).expand(stringWithMacro);
        if (run instanceof AbstractBuild) {
            s = s.replaceAll("\\$\\$", "\\$\\$\\$\\$");
            AbstractBuild build = (AbstractBuild)run;
            s = Util.replaceMacro((String)s, (VariableResolver)build.getBuildVariableResolver());
        }
        s = TokenMacro.expand(run, workspace, listener, s, throwException, privateTokens);
        return s;
    }

    @Nonnull
    protected static FilePath getWorkspace(@Nonnull AbstractBuild<?, ?> context) throws MacroEvaluationException {
        FilePath workspace = context.getWorkspace();
        if (workspace == null) {
            throw new MacroEvaluationException("Workspace is not accessible");
        }
        return workspace;
    }

    @CheckForNull
    public static Run<?, ?> getPreviousRun(@Nonnull Run<?, ?> run, TaskListener listener) {
        Run previousRun = run.getPreviousBuild();
        if (previousRun != null && previousRun.isBuilding()) {
            listener.getLogger().println(Messages.TokenMacro_Run_still_in_progress(previousRun.getDisplayName()));
            return null;
        }
        return previousRun;
    }
}

