/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.milestone;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.milestone.CancelledCause;
import org.jenkinsci.plugins.pipeline.milestone.Milestone;
import org.jenkinsci.plugins.pipeline.milestone.MilestoneAction;
import org.jenkinsci.plugins.pipeline.milestone.MilestoneStep;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowScanningUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearScanner;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class MilestoneStepExecution
extends AbstractSynchronousStepExecution<Void> {
    private static final Logger LOGGER = Logger.getLogger(MilestoneStepExecution.class.getName());
    @Inject(optional=true)
    private transient MilestoneStep step;
    @StepContextParameter
    private transient Run<?, ?> run;
    @StepContextParameter
    private transient FlowNode node;
    @StepContextParameter
    private transient TaskListener listener;
    private static final long serialVersionUID = 1L;

    public Void run() throws Exception {
        if (this.step.getLabel() != null) {
            this.node.addAction((Action)new MilestoneAction(this.step.getLabel()));
        }
        int ordinal = this.processOrdinal();
        this.tryToPass(this.run, this.getContext(), ordinal);
        return null;
    }

    private synchronized int processOrdinal() throws AbortException {
        List heads = this.node.getExecution().getCurrentHeads();
        if (heads.size() > 1) {
            throw new AbortException("Using a milestone step inside parallel is not allowed");
        }
        Predicate ordinalMatcher = FlowScanningUtils.hasActionPredicate(OrdinalAction.class);
        FlowNode lastOrdinalNode = new LinearScanner().findFirstMatch((Collection)heads, ordinalMatcher);
        Integer previousOrdinal = lastOrdinalNode != null ? Integer.valueOf(((OrdinalAction)lastOrdinalNode.getAction(OrdinalAction.class)).ordinal) : null;
        int nextOrdinal = 0;
        Integer stepOrdinal = this.step.getOrdinal();
        if (stepOrdinal != null) {
            if (previousOrdinal != null) {
                if (previousOrdinal >= stepOrdinal) {
                    throw new AbortException(String.format("Invalid ordinal %s, as the previous one was %s", nextOrdinal, previousOrdinal));
                }
                nextOrdinal = stepOrdinal;
            } else {
                nextOrdinal = stepOrdinal;
            }
        } else if (previousOrdinal != null) {
            nextOrdinal = previousOrdinal + 1;
        }
        this.node.addAction((Action)new OrdinalAction(nextOrdinal));
        return nextOrdinal;
    }

    private static Map<String, Map<Integer, Milestone>> getMilestonesByOrdinalByJob() {
        return ((MilestoneStep.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorOrDie(MilestoneStep.class)).getMilestonesByOrdinalByJob();
    }

    private synchronized void tryToPass(Run<?, ?> r, StepContext context, int ordinal) throws IOException, InterruptedException {
        Milestone milestone;
        LOGGER.log(Level.FINE, "build {0} trying to pass milestone {1}", new Object[]{r, ordinal});
        MilestoneStepExecution.println(context, "Trying to pass milestone " + ordinal);
        MilestoneStepExecution.load();
        Job job = r.getParent();
        String jobName = job.getFullName();
        Map<Integer, Milestone> milestonesInJob = MilestoneStepExecution.getMilestonesByOrdinalByJob().get(jobName);
        if (milestonesInJob == null) {
            milestonesInJob = new TreeMap<Integer, Milestone>();
            MilestoneStepExecution.getMilestonesByOrdinalByJob().put(jobName, milestonesInJob);
        }
        if ((milestone = milestonesInJob.get(ordinal)) == null) {
            milestone = new Milestone(ordinal);
            milestonesInJob.put(ordinal, milestone);
        }
        for (Map.Entry<Integer, Milestone> entry : milestonesInJob.entrySet()) {
            Milestone milestone2;
            if (entry.getKey().equals(ordinal) || !(milestone2 = entry.getValue()).wentAway(r)) continue;
            if (milestone2.ordinal >= ordinal) {
                throw new AbortException(String.format("Unordered milestone. Found ordinal %s but %s (or bigger) was expected.", ordinal, milestone2.ordinal + 1));
            }
            MilestoneStepExecution.cancelOldersInSight(milestone2, r);
        }
        if (milestone.lastBuild != null && r.getNumber() < milestone.lastBuild) {
            MilestoneStepExecution.cancel(context, milestone.lastBuild);
        } else {
            milestone.pass(context, r);
        }
        MilestoneStepExecution.cleanUp(job, jobName);
        MilestoneStepExecution.save();
    }

    private static synchronized void exit(Run<?, ?> r) {
        MilestoneStepExecution.load();
        LOGGER.log(Level.FINE, "exit {0}: {1}", new Object[]{r, MilestoneStepExecution.getMilestonesByOrdinalByJob()});
        Job job = r.getParent();
        String jobName = job.getFullName();
        Map<Integer, Milestone> milestonesInJob = MilestoneStepExecution.getMilestonesByOrdinalByJob().get(jobName);
        if (milestonesInJob == null) {
            return;
        }
        boolean modified = false;
        for (Milestone milestone : milestonesInJob.values()) {
            if (!milestone.wentAway(r)) continue;
            modified = true;
            MilestoneStepExecution.cancelOldersInSight(milestone, r);
        }
        if (modified) {
            MilestoneStepExecution.cleanUp(job, jobName);
        }
        if (r instanceof FlowExecutionOwner.Executable) {
            Integer lastMilestoneOrdinal = MilestoneStepExecution.getLastOrdinalInBuild((FlowExecutionOwner.Executable)r);
            if (lastMilestoneOrdinal == null) {
                return;
            }
            Milestone m = MilestoneStepExecution.getFirstWithoutInSight(milestonesInJob);
            while (m != null && milestonesInJob.size() - 1 > lastMilestoneOrdinal) {
                modified = true;
                milestonesInJob.remove(m.ordinal);
                m = MilestoneStepExecution.getFirstWithoutInSight(milestonesInJob);
            }
            if (milestonesInJob.isEmpty()) {
                modified = true;
                MilestoneStepExecution.getMilestonesByOrdinalByJob().remove(jobName);
            }
        }
        if (modified) {
            MilestoneStepExecution.save();
        }
    }

    @CheckForNull
    private static Integer getLastOrdinalInBuild(FlowExecutionOwner.Executable r) {
        int lastMilestoneOrdinal = 0;
        FlowExecutionOwner owner = r.asFlowExecutionOwner();
        if (owner == null) {
            return null;
        }
        try {
            List heads = owner.get().getCurrentHeads();
            if (heads.size() == 1) {
                Predicate ordinalMatcher = FlowScanningUtils.hasActionPredicate(OrdinalAction.class);
                FlowNode lastOrdinalNode = new LinearScanner().findFirstMatch((Collection)heads, ordinalMatcher);
                return lastOrdinalNode != null ? Integer.valueOf(((OrdinalAction)lastOrdinalNode.getAction(OrdinalAction.class)).ordinal) : null;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to traverse flow graph to search the last milestone ordinal", e);
        }
        return lastMilestoneOrdinal;
    }

    @CheckForNull
    private static Milestone getFirstWithoutInSight(Map<Integer, Milestone> milestones) {
        for (Map.Entry<Integer, Milestone> entry : milestones.entrySet()) {
            Milestone m = entry.getValue();
            if (!m.inSight.isEmpty()) continue;
            return m;
        }
        return null;
    }

    private static void cancelOldersInSight(Milestone milestone, Run<?, ?> r) {
        for (Integer inSightNumber : milestone.inSight) {
            if (r.getNumber() <= inSightNumber) continue;
            Run olderInSightBuild = r.getParent().getBuildByNumber(inSightNumber.intValue());
            Executor e = olderInSightBuild.getExecutor();
            if (e != null) {
                e.interrupt(Result.NOT_BUILT, new CauseOfInterruption[]{new CancelledCause(r.getExternalizableId())});
                continue;
            }
            LOGGER.log(Level.WARNING, "could not cancel an older flow because it has no assigned executor");
        }
    }

    private static void println(StepContext context, String message) {
        if (!context.isReady()) {
            LOGGER.log(Level.FINE, "cannot print message \u2018{0}\u2019 to dead {1}", new Object[]{message, context});
            return;
        }
        try {
            ((TaskListener)context.get(TaskListener.class)).getLogger().println(message);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "failed to print message to dead " + context, x);
        }
    }

    private static void cancel(StepContext context, Integer build) throws IOException, InterruptedException {
        if (context.isReady()) {
            MilestoneStepExecution.println(context, "Canceled since build #" + build + " already got here");
            Run r = (Run)context.get(Run.class);
            String job = "";
            if (r != null) {
                job = r.getParent().getFullName();
            }
            throw new FlowInterruptedException(Result.NOT_BUILT, new CauseOfInterruption[]{new CancelledCause(job + "#" + build)});
        }
        LOGGER.log(Level.WARNING, "cannot cancel dead #" + build);
    }

    private static void cleanUp(Job<?, ?> job, String jobName) {
        Map<Integer, Milestone> milestonesInJob = MilestoneStepExecution.getMilestonesByOrdinalByJob().get(jobName);
        assert (milestonesInJob != null);
        for (Map.Entry<Integer, Milestone> entry : milestonesInJob.entrySet()) {
            Set<Integer> inSight = entry.getValue().inSight;
            Iterator<Integer> it2 = inSight.iterator();
            while (it2.hasNext()) {
                Integer number = it2.next();
                if (job.getBuildByNumber(number.intValue()) != null) continue;
                LOGGER.log(Level.WARNING, "Cleaning up apparently deleted {0}#{1}", new Object[]{jobName, number});
                it2.remove();
            }
        }
    }

    private static void load() {
        Jenkins.getActiveInstance().getDescriptorOrDie(MilestoneStep.class).load();
    }

    private static void save() {
        Jenkins.getActiveInstance().getDescriptorOrDie(MilestoneStep.class).save();
    }

    @Extension
    public static final class Listener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> r, TaskListener listener) {
            if (!(r instanceof FlowExecutionOwner.Executable) || ((FlowExecutionOwner.Executable)r).asFlowExecutionOwner() == null) {
                return;
            }
            MilestoneStepExecution.exit(r);
        }
    }

    private static class OrdinalAction
    extends InvisibleAction {
        int ordinal;

        public OrdinalAction(int ordinal) {
            this.ordinal = ordinal;
        }
    }
}

