/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.scm.api.SCMFile;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitSCMFile
extends SCMFile {
    private final GitSCMFileSystem fs;

    public GitSCMFile(GitSCMFileSystem fs) {
        this.fs = fs;
    }

    public GitSCMFile(GitSCMFileSystem fs, @NonNull GitSCMFile parent, String name) {
        super((SCMFile)parent, name);
        this.fs = fs;
    }

    @NonNull
    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new GitSCMFile(this.fs, this, name);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        return this.fs.invoke(new GitSCMFileSystem.FSFunction<List<SCMFile>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<SCMFile> invoke(Repository repository) throws IOException, InterruptedException {
                RevWalk walk = new RevWalk(repository);
                Throwable throwable = null;
                RevCommit commit = walk.parseCommit((AnyObjectId)GitSCMFile.this.fs.getCommitId());
                RevTree tree = commit.getTree();
                if (GitSCMFile.this.isRoot()) {
                    try (TreeWalk tw = new TreeWalk(repository);){
                        tw.addTree((AnyObjectId)tree);
                        tw.setRecursive(false);
                        ArrayList<SCMFile> result = new ArrayList<SCMFile>();
                        while (tw.next()) {
                            result.add(new GitSCMFile(GitSCMFile.this.fs, GitSCMFile.this, tw.getNameString()));
                        }
                        ArrayList<SCMFile> arrayList = result;
                        return arrayList;
                    }
                }
                TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)GitSCMFile.this.getPath(), (RevTree)tree);
                Throwable throwable2 = null;
                try {
                    if (tw == null) {
                        throw new FileNotFoundException();
                    }
                    FileMode fileMode = tw.getFileMode(0);
                    if (fileMode == FileMode.MISSING) {
                        throw new FileNotFoundException();
                    }
                    if (fileMode != FileMode.TREE) {
                        throw new IOException("Not a directory");
                    }
                    tw.enterSubtree();
                    ArrayList<SCMFile> result = new ArrayList<SCMFile>();
                    while (tw.next()) {
                        result.add(new GitSCMFile(GitSCMFile.this.fs, GitSCMFile.this, tw.getNameString()));
                    }
                    ArrayList<SCMFile> arrayList = result;
                    return arrayList;
                }
                catch (Throwable throwable4) {
                    try {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (tw != null) {
                            if (throwable2 != null) {
                                try {
                                    tw.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                tw.close();
                            }
                        }
                    }
                }
                finally {
                    if (walk != null) {
                        if (throwable != null) {
                            try {
                                walk.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            walk.close();
                        }
                    }
                }
            }
        });
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.fs.lastModified();
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        return this.fs.invoke(new GitSCMFileSystem.FSFunction<SCMFile.Type>(){

            /*
             * Exception decompiling
             */
            @Override
            public SCMFile.Type invoke(Repository repository) throws IOException, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 65[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        return this.fs.invoke(new GitSCMFileSystem.FSFunction<InputStream>(){

            /*
             * Exception decompiling
             */
            @Override
            public InputStream invoke(Repository repository) throws IOException, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }
}

