/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import com.google.common.base.Function;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

public class SparseCheckoutPath
extends AbstractDescribableImpl<SparseCheckoutPath>
implements Serializable {
    private static final long serialVersionUID = -6177158367915899356L;
    public static final transient SparseCheckoutPathToPath SPARSE_CHECKOUT_PATH_TO_PATH = new SparseCheckoutPathToPath();
    private String path;

    @DataBoundConstructor
    public SparseCheckoutPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SparseCheckoutPath)) {
            return false;
        }
        SparseCheckoutPath that = (SparseCheckoutPath)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    public Descriptor<SparseCheckoutPath> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SparseCheckoutPath> {
        public String getDisplayName() {
            return "Path";
        }
    }

    private static class SparseCheckoutPathToPath
    implements Function<SparseCheckoutPath, String>,
    Serializable {
        private SparseCheckoutPathToPath() {
        }

        public String apply(SparseCheckoutPath sparseCheckoutPath) {
            return sparseCheckoutPath.getPath();
        }
    }
}

