/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.AgentProtocol;
import jenkins.model.Jenkins;
import jenkins.security.ChannelConfigurator;
import jenkins.security.HMACConfidentialKey;
import jenkins.slaves.Messages;
import jenkins.slaves.NioChannelSelector;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.engine.JnlpServerHandshake;
import org.jenkinsci.remoting.nio.NioChannelHub;

@Extension
@Symbol(value={"jnlp"})
public class JnlpSlaveAgentProtocol
extends AgentProtocol {
    @Inject
    NioChannelSelector hub;
    private static final Logger LOGGER = Logger.getLogger(JnlpSlaveAgentProtocol.class.getName());
    public static final HMACConfidentialKey SLAVE_SECRET = new HMACConfidentialKey(JnlpSlaveAgentProtocol.class, "secret");
    private static final boolean OPT_IN;

    @Override
    public boolean isOptIn() {
        return OPT_IN;
    }

    @Override
    public String getName() {
        return "JNLP-connect";
    }

    @Override
    public String getDisplayName() {
        return Messages.JnlpSlaveAgentProtocol_displayName();
    }

    @Override
    public void handle(Socket socket) throws IOException, InterruptedException {
        new Handler(this.hub.getHub(), socket).run();
    }

    static {
        byte hash = Util.fromHexString(Jenkins.getInstance().getLegacyInstanceId())[0];
        OPT_IN = hash % 10 == 0;
    }

    protected static class Handler
    extends JnlpServerHandshake {
        @Deprecated
        public Handler(Socket socket) throws IOException {
            this(null, socket);
        }

        public Handler(NioChannelHub hub, Socket socket) throws IOException {
            super(hub, Computer.threadPoolForRemoting, socket);
        }

        protected void run() throws IOException, InterruptedException {
            String secret = this.in.readUTF();
            String nodeName = this.in.readUTF();
            if (!SLAVE_SECRET.mac(nodeName).equals(secret)) {
                this.error("Unauthorized access");
                return;
            }
            SlaveComputer computer = (SlaveComputer)Jenkins.getInstance().getComputer(nodeName);
            if (computer == null) {
                this.error("No such agent: " + nodeName);
                return;
            }
            if (computer.getChannel() != null) {
                this.error(nodeName + " is already connected to this master. Rejecting this connection.");
                return;
            }
            this.out.println("Welcome");
            this.jnlpConnect(computer);
        }

        protected Channel jnlpConnect(SlaveComputer computer) throws InterruptedException, IOException {
            final String nodeName = computer.getName();
            OutputStream log = computer.openLogFile();
            PrintWriter logw = new PrintWriter(log, true);
            logw.println("JNLP agent connected from " + this.socket.getInetAddress());
            try {
                ChannelBuilder cb = this.createChannelBuilder(nodeName);
                for (ChannelConfigurator cc : ChannelConfigurator.all()) {
                    cc.onChannelBuilding(cb, computer);
                }
                computer.setChannel(cb.withHeaderStream(log).build(this.socket), log, new Channel.Listener(){

                    @Override
                    public void onClosed(Channel channel, IOException cause) {
                        if (cause != null) {
                            LOGGER.log(Level.WARNING, Thread.currentThread().getName() + " for " + nodeName + " terminated", cause);
                        }
                        try {
                            Handler.this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                return computer.getChannel();
            }
            catch (AbortException e) {
                logw.println(e.getMessage());
                logw.println("Failed to establish the connection with the agent");
                throw e;
            }
            catch (IOException e) {
                logw.println("Failed to establish the connection with the agent " + nodeName);
                e.printStackTrace(logw);
                throw e;
            }
        }
    }
}

