/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import hudson.Functions;
import hudson.model.Failure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.security.s2m.ConfigDirectory;
import jenkins.security.s2m.FilePathRule;
import jenkins.security.s2m.OpMatcher;

class FilePathRuleConfig
extends ConfigDirectory<FilePathRule, List<FilePathRule>> {
    private static final Pattern PARSER = Pattern.compile("(allow|deny)\\s+([a-z,]+)\\s+(.*)");

    FilePathRuleConfig(File file) {
        super(file);
    }

    @Override
    protected List<FilePathRule> create() {
        return new ArrayList<FilePathRule>();
    }

    @Override
    protected List<FilePathRule> readOnly(List<FilePathRule> base) {
        return ImmutableList.copyOf(base);
    }

    @Override
    protected FilePathRule parse(String line) {
        Matcher m;
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        line = line.replace("<BUILDDIR>", "<JOBDIR>/builds/<BUILDID>");
        line = line.replace("<BUILDID>", "(?:[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]_[0-9][0-9]-[0-9][0-9]-[0-9][0-9]|[0-9]+)");
        line = line.replace("<JOBDIR>", "<JENKINS_HOME>/jobs/.+");
        line = line.replace("<JENKINS_HOME>", "\\Q" + Jenkins.getInstance().getRootDir().getPath() + "\\E");
        if (Functions.isWindows()) {
            line = line.replace("/", "\\\\");
        }
        if (!(m = PARSER.matcher(line)).matches()) {
            throw new Failure("Invalid filter rule line: " + line);
        }
        try {
            return new FilePathRule(Pattern.compile(m.group(3)), this.createOpMatcher(m.group(2)), m.group(1).equals("allow"));
        }
        catch (Exception e) {
            throw new Failure("Invalid filter rule line: " + line + "\n" + Functions.printThrowable(e));
        }
    }

    private OpMatcher createOpMatcher(String token) {
        if (token.equals("all")) {
            return OpMatcher.ALL;
        }
        final ImmutableSet ops = ImmutableSet.copyOf((Object[])token.split(","));
        return new OpMatcher(){

            @Override
            public boolean matches(String op) {
                return ops.contains((Object)op);
            }
        };
    }

    public boolean checkFileAccess(String op, File path) throws SecurityException {
        String pathStr = null;
        for (FilePathRule rule : (List)this.get()) {
            if (!rule.op.matches(op)) continue;
            if (pathStr == null) {
                pathStr = path.getPath();
                if (Functions.isWindows()) {
                    pathStr = pathStr.replace('/', '\\');
                }
            }
            if (!rule.path.matcher(pathStr).matches()) continue;
            return rule.allow;
        }
        return false;
    }
}

