/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.security.BasicHeaderAuthenticator;
import jenkins.util.SystemProperties;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.AuthenticationDetailsSource;
import org.acegisecurity.ui.AuthenticationDetailsSourceImpl;

@Extension
public class BasicHeaderRealPasswordAuthenticator
extends BasicHeaderAuthenticator {
    private AuthenticationDetailsSource authenticationDetailsSource = new AuthenticationDetailsSourceImpl();
    private static final Logger LOGGER = Logger.getLogger(BasicHeaderRealPasswordAuthenticator.class.getName());
    public static boolean DISABLE = SystemProperties.getBoolean("jenkins.security.ignoreBasicAuth");

    @Override
    public Authentication authenticate(HttpServletRequest req, HttpServletResponse rsp, String username, String password) throws IOException, ServletException {
        if (DISABLE) {
            return null;
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails(req));
        try {
            Authentication a = Jenkins.getInstance().getSecurityRealm().getSecurityComponents().manager.authenticate((Authentication)authRequest);
            LOGGER.log(Level.FINER, "Authentication success: {0}", a);
            return a;
        }
        catch (AuthenticationException failed) {
            LOGGER.log(Level.FINER, "Authentication request for user: {0} failed: {1}", new Object[]{username, failed});
            return null;
        }
    }
}

