/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Node;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public abstract class NodeListener
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(NodeListener.class.getName());

    protected void onCreated(@Nonnull Node node) {
    }

    protected void onUpdated(@Nonnull Node oldOne, @Nonnull Node newOne) {
    }

    protected void onDeleted(@Nonnull Node node) {
    }

    public static void fireOnCreated(@Nonnull Node node) {
        for (NodeListener nl : NodeListener.all()) {
            try {
                nl.onCreated(node);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.WARNING, "Listener invocation failed", ex);
            }
        }
    }

    public static void fireOnUpdated(@Nonnull Node oldOne, @Nonnull Node newOne) {
        for (NodeListener nl : NodeListener.all()) {
            try {
                nl.onUpdated(oldOne, newOne);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.WARNING, "Listener invocation failed", ex);
            }
        }
    }

    public static void fireOnDeleted(@Nonnull Node node) {
        for (NodeListener nl : NodeListener.all()) {
            try {
                nl.onDeleted(node);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.WARNING, "Listener invocation failed", ex);
            }
        }
    }

    @Nonnull
    public static List<NodeListener> all() {
        return ExtensionList.lookup(NodeListener.class);
    }
}

