/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import java.io.IOException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=500.0)
@Symbol(value={"masterBuild"})
public class MasterBuildConfiguration
extends GlobalConfiguration {
    public int getNumExecutors() {
        return Jenkins.getInstance().getNumExecutors();
    }

    public String getLabelString() {
        return Jenkins.getInstance().getLabelString();
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        Jenkins j = Jenkins.getInstance();
        try {
            j.setNumExecutors(json.getInt("numExecutors"));
            if (req.hasParameter("master.mode")) {
                j.setMode(Node.Mode.valueOf(req.getParameter("master.mode")));
            } else {
                j.setMode(Node.Mode.NORMAL);
            }
            j.setLabelString(json.optString("labelString", ""));
            return true;
        }
        catch (IOException e) {
            throw new Descriptor.FormException(e, "numExecutors");
        }
    }
}

