/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.model.Descriptor;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.ProjectNamingStrategy;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=250.0)
@Symbol(value={"projectNamingStrategy"})
public class GlobalProjectNamingStrategyConfiguration
extends GlobalConfiguration {
    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        Jenkins j = Jenkins.getInstance();
        JSONObject optJSONObject = json.optJSONObject("useProjectNamingStrategy");
        if (optJSONObject != null) {
            JSONObject strategyObject = optJSONObject.getJSONObject("namingStrategy");
            String className = strategyObject.getString("$class");
            try {
                Class<?> clazz = Class.forName(className, true, Jenkins.getInstance().getPluginManager().uberClassLoader);
                ProjectNamingStrategy strategy = (ProjectNamingStrategy)req.bindJSON(clazz, strategyObject);
                j.setProjectNamingStrategy(strategy);
            }
            catch (ClassNotFoundException e) {
                throw new Descriptor.FormException(e, "namingStrategy");
            }
        }
        if (j.getProjectNamingStrategy() == null) {
            j.setProjectNamingStrategy(ProjectNamingStrategy.DefaultProjectNamingStrategy.DEFAULT_NAMING_STRATEGY);
        }
        return true;
    }
}

