/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.console.ModelHyperlinkNote;
import hudson.model.TaskListener;
import hudson.model.User;
import java.io.Serializable;
import java.util.Collections;
import javax.annotation.CheckForNull;
import jenkins.model.Messages;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class CauseOfInterruption
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Exported
    public abstract String getShortDescription();

    public void print(TaskListener listener) {
        listener.getLogger().println(this.getShortDescription());
    }

    public static final class UserInterruption
    extends CauseOfInterruption {
        private final String user;
        private static final long serialVersionUID = 1L;

        public UserInterruption(User user) {
            this.user = user.getId();
        }

        public UserInterruption(String userId) {
            this.user = userId;
        }

        @CheckForNull
        public User getUser() {
            return User.get(this.user, false, Collections.emptyMap());
        }

        @Override
        public String getShortDescription() {
            return Messages.CauseOfInterruption_ShortDescription(this.user);
        }

        @Override
        public void print(TaskListener listener) {
            User userInstance = this.getUser();
            listener.getLogger().println(Messages.CauseOfInterruption_ShortDescription(userInstance != null ? ModelHyperlinkNote.encodeTo(userInstance) : this.user));
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserInterruption that = (UserInterruption)o;
            return this.user.equals(that.user);
        }

        public int hashCode() {
            return this.user.hashCode();
        }
    }
}

