/*
 * Decompiled with CFR 0.152.
 */
package jenkins.management;

import hudson.Extension;
import hudson.Functions;
import hudson.diagnosis.ReverseProxySetupMonitor;
import hudson.model.AdministrativeMonitor;
import hudson.model.PageDecorator;
import hudson.util.HudsonIsLoading;
import hudson.util.HudsonIsRestarting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.management.Messages;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Restricted(value={NoExternalUse.class})
public class AdministrativeMonitorsDecorator
extends PageDecorator {
    private final Collection<String> ignoredJenkinsRestOfUrls = new ArrayList<String>();

    public AdministrativeMonitorsDecorator() {
        this.ignoredJenkinsRestOfUrls.add("manage");
        this.ignoredJenkinsRestOfUrls.add("contextMenu");
        this.ignoredJenkinsRestOfUrls.add("configure");
    }

    @Override
    public String getDisplayName() {
        return Messages.AdministrativeMonitorsDecorator_DisplayName();
    }

    public int getActiveAdministrativeMonitorsCount() {
        return this.getActiveAdministrativeMonitors().size();
    }

    public Collection<AdministrativeMonitor> getActiveAdministrativeMonitors() {
        ArrayList<AdministrativeMonitor> active = new ArrayList<AdministrativeMonitor>();
        ArrayList<AdministrativeMonitor> ams = new ArrayList<AdministrativeMonitor>(Jenkins.getInstance().administrativeMonitors);
        for (AdministrativeMonitor am : ams) {
            if (am instanceof ReverseProxySetupMonitor || !am.isEnabled() || !am.isActivated()) continue;
            active.add(am);
        }
        return active;
    }

    public boolean shouldDisplay() throws IOException, ServletException {
        String url;
        if (!Functions.hasPermission(Jenkins.ADMINISTER)) {
            return false;
        }
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return false;
        }
        List ancestors = req.getAncestors();
        if (ancestors == null || ancestors.size() == 0) {
            return false;
        }
        Ancestor a = (Ancestor)ancestors.get(ancestors.size() - 1);
        Object o = a.getObject();
        if (o instanceof HudsonIsLoading) {
            return false;
        }
        if (o instanceof HudsonIsRestarting) {
            return false;
        }
        if (o instanceof Jenkins && this.ignoredJenkinsRestOfUrls.contains(url = a.getRestOfUrl())) {
            return false;
        }
        return this.getActiveAdministrativeMonitorsCount() != 0;
    }
}

