/*
 * Decompiled with CFR 0.152.
 */
package jenkins.management;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Restricted(value={NoExternalUse.class})
public class AdministrativeMonitorsConfiguration
extends GlobalConfiguration {
    private static Logger LOGGER = Logger.getLogger(AdministrativeMonitorsConfiguration.class.getName());

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        for (AdministrativeMonitor am : AdministrativeMonitor.all()) {
            try {
                boolean disable = !json.getJSONArray("administrativeMonitor").contains((Object)am.id);
                am.disable(disable);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to process form submission for " + am.id, e);
            }
        }
        return true;
    }
}

