/*
 * Decompiled with CFR 0.152.
 */
package jenkins.install;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.install.InstallUtil;
import jenkins.install.UpgradeWizard;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class InstallState
implements ExtensionPoint {
    @Extension
    public static final InstallState UNKNOWN = new InstallState("UNKNOWN", true);
    @Extension
    public static final InstallState RUNNING = new InstallState("RUNNING", true);
    @Extension
    public static final InstallState INITIAL_SETUP_COMPLETED = new InstallState("INITIAL_SETUP_COMPLETED", true){

        @Override
        public void initializeState() {
            Jenkins j = Jenkins.getInstance();
            try {
                j.getSetupWizard().completeSetup();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            j.setInstallState(RUNNING);
        }
    };
    @Extension
    public static final InstallState CREATE_ADMIN_USER = new InstallState("CREATE_ADMIN_USER", false){

        @Override
        public void initializeState() {
            Jenkins j = Jenkins.getInstance();
            if (!j.getSetupWizard().isUsingSecurityDefaults()) {
                InstallUtil.proceedToNextStateFrom(this);
            }
        }
    };
    @Extension
    public static final InstallState INITIAL_PLUGINS_INSTALLING = new InstallState("INITIAL_PLUGINS_INSTALLING", false);
    @Extension
    public static final InstallState INITIAL_SECURITY_SETUP = new InstallState("INITIAL_SECURITY_SETUP", false){

        @Override
        public void initializeState() {
            try {
                Jenkins.getInstance().getSetupWizard().init(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            InstallUtil.proceedToNextStateFrom(INITIAL_SECURITY_SETUP);
        }
    };
    @Extension
    public static final InstallState NEW = new InstallState("NEW", false);
    @Extension
    public static final InstallState RESTART = new InstallState("RESTART", true){

        @Override
        public void initializeState() {
            InstallUtil.saveLastExecVersion();
        }
    };
    @Extension
    public static final InstallState UPGRADE = new UpgradeWizard();
    @Extension
    public static final InstallState DOWNGRADE = new InstallState("DOWNGRADE", true){

        @Override
        public void initializeState() {
            InstallUtil.saveLastExecVersion();
        }
    };
    private static final Logger LOGGER = Logger.getLogger(InstallState.class.getName());
    public static final InstallState TEST = new InstallState("TEST", true);
    public static final InstallState DEVELOPMENT = new InstallState("DEVELOPMENT", true);
    private final boolean isSetupComplete;
    private final String name;

    public InstallState(@Nonnull String name, boolean isSetupComplete) {
        this.name = name;
        this.isSetupComplete = isSetupComplete;
    }

    public void initializeState() {
    }

    public Object readResolve() {
        if (StringUtils.isBlank((String)this.name)) {
            LOGGER.log(Level.WARNING, "Read install state with blank name: ''{0}''. It will be ignored", this.name);
            return UNKNOWN;
        }
        InstallState state = InstallState.valueOf(this.name);
        if (state == null) {
            LOGGER.log(Level.WARNING, "Cannot locate an extension point for the state ''{0}''. It will be ignored", this.name);
            return UNKNOWN;
        }
        return state;
    }

    public boolean isSetupComplete() {
        return this.isSetupComplete;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstallState) {
            return this.name.equals(((InstallState)obj).name());
        }
        return false;
    }

    public String toString() {
        return "InstallState (" + this.name + ")";
    }

    @CheckForNull
    public static InstallState valueOf(@Nonnull String name) {
        for (InstallState state : InstallState.all()) {
            if (!name.equals(state.name)) continue;
            return state;
        }
        return null;
    }

    static ExtensionList<InstallState> all() {
        return ExtensionList.lookup(InstallState.class);
    }
}

