/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnosis;

import com.sun.akuma.JavaVMArguments;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.AdministrativeMonitor;
import hudson.util.jna.Kernel32Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.diagnosis.HsErrPidFile;
import jenkins.model.Jenkins;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;

@Extension(optional=true)
@Symbol(value={"hsErrPid"})
public class HsErrPidList
extends AdministrativeMonitor {
    final List<HsErrPidFile> files = new ArrayList<HsErrPidFile>();
    private MappedByteBuffer map;
    private static final String ERROR_FILE_OPTION = "-XX:ErrorFile=";
    private static final Logger LOGGER = Logger.getLogger(HsErrPidList.class.getName());

    public HsErrPidList() {
        if (Functions.getIsUnitTest()) {
            return;
        }
        try {
            try (FileChannel ch = new FileInputStream(this.getSecretKeyFile()).getChannel();){
                this.map = ch.map(FileChannel.MapMode.READ_ONLY, 0L, 1L);
            }
            this.scan("./hs_err_pid%p.log");
            if (Functions.isWindows()) {
                File dir = Kernel32Utils.getTempDir();
                if (dir != null) {
                    this.scan(dir.getPath() + "\\hs_err_pid%p.log");
                }
            } else {
                this.scan("/tmp/hs_err_pid%p.log");
            }
            JavaVMArguments args = JavaVMArguments.current();
            for (String a : args) {
                if (!a.startsWith(ERROR_FILE_OPTION)) continue;
                this.scan(a.substring(ERROR_FILE_OPTION.length()));
            }
        }
        catch (UnsupportedOperationException e) {
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to list up hs_err_pid files", e);
        }
    }

    @Override
    public String getDisplayName() {
        return "JVM Crash Reports";
    }

    public List<HsErrPidFile> getFiles() {
        return this.files;
    }

    private void scan(String pattern) {
        LOGGER.fine("Scanning " + pattern + " for hs_err_pid files");
        pattern = pattern.replace("%p", "*").replace("%%", "%");
        File f = new File(pattern).getAbsoluteFile();
        if (!pattern.contains("*")) {
            this.scanFile(f);
        } else {
            File commonParent;
            for (commonParent = f; commonParent != null && commonParent.getPath().contains("*"); commonParent = commonParent.getParentFile()) {
            }
            if (commonParent == null) {
                LOGGER.warning("Failed to process " + f);
                return;
            }
            FileSet fs = Util.createFileSet(commonParent, f.getPath().substring(commonParent.getPath().length() + 1), null);
            DirectoryScanner ds = fs.getDirectoryScanner(new Project());
            for (String child : ds.getIncludedFiles()) {
                this.scanFile(new File(commonParent, child));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void scanFile(File log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File getSecretKeyFile() {
        return new File(Jenkins.getInstance().getRootDir(), "secret.key");
    }

    private boolean findHeader(BufferedReader r) throws IOException {
        for (int i = 0; i < 5; ++i) {
            String line = r.readLine();
            if (line == null) {
                return false;
            }
            if (!line.startsWith("# A fatal error has been detected by the Java Runtime Environment:")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActivated() {
        return !this.files.isEmpty();
    }
}

