/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import hudson.init.InitMilestone;
import hudson.init.InitReactorListener;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import hudson.util.Service;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Configuration;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.ReactorException;
import org.jvnet.hudson.reactor.ReactorListener;
import org.jvnet.hudson.reactor.Task;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class InitReactorRunner {
    private static final int TWICE_CPU_NUM = SystemProperties.getInteger(InitReactorRunner.class.getName() + ".concurrency", Runtime.getRuntime().availableProcessors() * 2);
    private static final Logger LOGGER = Logger.getLogger(InitReactorRunner.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Reactor reactor) throws InterruptedException, ReactorException, IOException {
        reactor.addAll(InitMilestone.ordering().discoverTasks(reactor));
        ExecutorService es = Jenkins.PARALLEL_LOAD ? new ThreadPoolExecutor(TWICE_CPU_NUM, TWICE_CPU_NUM, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory()) : Executors.newSingleThreadExecutor(new NamingThreadFactory(new DaemonThreadFactory(), "InitReactorRunner"));
        try {
            reactor.execute((Executor)es, this.buildReactorListener());
        }
        finally {
            es.shutdownNow();
        }
    }

    private ReactorListener buildReactorListener() throws IOException {
        List<InitReactorListener> r = Service.loadInstances(Thread.currentThread().getContextClassLoader(), InitReactorListener.class);
        r.add((InitReactorListener)new ReactorListener(){
            final Level level = Level.parse(Configuration.getStringConfigParameter("initLogLevel", "FINE"));

            public void onTaskStarted(Task t) {
                LOGGER.log(this.level, "Started {0}", InitReactorRunner.getDisplayName(t));
            }

            public void onTaskCompleted(Task t) {
                LOGGER.log(this.level, "Completed {0}", InitReactorRunner.getDisplayName(t));
            }

            public void onTaskFailed(Task t, Throwable err, boolean fatal) {
                LOGGER.log(Level.SEVERE, "Failed " + InitReactorRunner.getDisplayName(t), err);
            }

            public void onAttained(Milestone milestone) {
                Level lv = this.level;
                String s = "Attained " + milestone.toString();
                if (milestone instanceof InitMilestone) {
                    lv = Level.INFO;
                    InitReactorRunner.this.onInitMilestoneAttained((InitMilestone)milestone);
                    s = milestone.toString();
                }
                LOGGER.log(lv, s);
            }
        });
        return new ReactorListener.Aggregator(r);
    }

    @Restricted(value={NoExternalUse.class})
    public static String getDisplayName(Task t) {
        try {
            return t.getDisplayName();
        }
        catch (Error | RuntimeException x) {
            LOGGER.log(Level.WARNING, "failed to find displayName of " + t, x);
            return t.toString();
        }
    }

    protected void onInitMilestoneAttained(InitMilestone milestone) {
    }
}

