/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RewindableFileOutputStream
extends OutputStream {
    protected final File out;
    private boolean closed;
    private OutputStream current;

    public RewindableFileOutputStream(File out) {
        this.out = out;
    }

    private synchronized OutputStream current() throws IOException {
        if (this.current == null) {
            if (!this.closed) {
                try {
                    this.current = new FileOutputStream(this.out, false);
                }
                catch (FileNotFoundException e) {
                    throw new IOException("Failed to open " + this.out, e);
                }
            } else {
                throw new IOException(this.out.getName() + " stream is closed");
            }
        }
        return this.current;
    }

    @Override
    public void write(int b) throws IOException {
        this.current().write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.current().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.current().write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.current().flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closeCurrent();
        this.closed = true;
    }

    public synchronized void rewind() throws IOException {
        this.closeCurrent();
    }

    private void closeCurrent() throws IOException {
        if (this.current != null) {
            this.current.close();
            this.current = null;
        }
    }
}

