/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.extended.DynamicProxyConverter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.AnnotationMapper;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Label;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.remoting.ClassFilter;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.RobustCollectionConverter;
import hudson.util.RobustMapConverter;
import hudson.util.RobustReflectionConverter;
import hudson.util.xstream.ImmutableListConverter;
import hudson.util.xstream.ImmutableMapConverter;
import hudson.util.xstream.ImmutableSetConverter;
import hudson.util.xstream.ImmutableSortedSetConverter;
import hudson.util.xstream.MapperDelegate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class XStream2
extends XStream {
    private RobustReflectionConverter reflectionConverter;
    private final ThreadLocal<Boolean> oldData = new ThreadLocal();
    @CheckForNull
    private final ClassOwnership classOwnership;
    private final Map<String, Class<?>> compatibilityAliases = new ConcurrentHashMap();
    private MapperInjectionPoint mapperInjectionPoint;

    public XStream2() {
        this.init();
        this.classOwnership = null;
    }

    public XStream2(HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(hierarchicalStreamDriver);
        this.init();
        this.classOwnership = null;
    }

    XStream2(ClassOwnership classOwnership) {
        this.init();
        this.classOwnership = classOwnership;
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        Jenkins h = Jenkins.getInstanceOrNull();
        if (h != null && h.pluginManager != null && h.pluginManager.uberClassLoader != null) {
            this.setClassLoader(h.pluginManager.uberClassLoader);
        }
        Object o = super.unmarshal(reader, root, dataHolder);
        if (this.oldData.get() != null) {
            this.oldData.remove();
            if (o instanceof Saveable) {
                OldDataMonitor.report((Saveable)o, "1.106");
            }
        }
        return o;
    }

    protected Converter createDefaultConverter() {
        this.reflectionConverter = new RobustReflectionConverter(this.getMapper(), new JVM().bestReflectionProvider(), new PluginClassOwnership());
        return this.reflectionConverter;
    }

    @Restricted(value={NoExternalUse.class})
    public void addCriticalField(Class<?> clazz, String field) {
        this.reflectionConverter.addCriticalField(clazz, field);
    }

    static String trimVersion(String version) {
        return version.replaceFirst(" .+$", "");
    }

    private void init() {
        this.addImmutableType(Result.class);
        this.registerConverter((Converter)new RobustCollectionConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new RobustMapConverter(this.getMapper()), 10);
        this.registerConverter((Converter)new ImmutableMapConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new ImmutableSortedSetConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new ImmutableSetConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new ImmutableListConverter(this.getMapper(), this.getReflectionProvider()), 10);
        this.registerConverter((Converter)new CopyOnWriteMap.Tree.ConverterImpl(this.getMapper()), 10);
        this.registerConverter((Converter)new DescribableList.ConverterImpl(this.getMapper()), 10);
        this.registerConverter(new Label.ConverterImpl(), 10);
        this.registerConverter(new AssociatedConverterImpl(this), -10);
        this.registerConverter(new BlacklistedTypesConverter(), 10000);
        this.registerConverter((Converter)new DynamicProxyConverter(this.getMapper()){

            public boolean canConvert(Class type) {
                return type != null && super.canConvert(type);
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                throw new ConversionException("<dynamic-proxy> not supported");
            }
        }, 10000);
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        CompatibilityMapper m = new CompatibilityMapper((Mapper)new MapperWrapper((Mapper)next){

            public String serializedClass(Class type) {
                if (type != null && ImmutableMap.class.isAssignableFrom(type)) {
                    return super.serializedClass(ImmutableMap.class);
                }
                if (type != null && ImmutableList.class.isAssignableFrom(type)) {
                    return super.serializedClass(ImmutableList.class);
                }
                return super.serializedClass(type);
            }
        });
        AnnotationMapper a = new AnnotationMapper((Mapper)m, this.getConverterRegistry(), this.getConverterLookup(), this.getClassLoader(), this.getReflectionProvider(), this.getJvm());
        a.autodetectAnnotations(true);
        this.mapperInjectionPoint = new MapperInjectionPoint((Mapper)a);
        return this.mapperInjectionPoint;
    }

    public Mapper getMapperInjectionPoint() {
        return this.mapperInjectionPoint.getDelegate();
    }

    @Deprecated
    public void toXML(Object obj, OutputStream out) {
        super.toXML(obj, out);
    }

    public void toXMLUTF8(Object obj, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.toXML(obj, w);
    }

    public void setMapper(Mapper m) {
        this.mapperInjectionPoint.setDelegate(m);
    }

    public void addCompatibilityAlias(String oldClassName, Class newClass) {
        this.compatibilityAliases.put(oldClassName, newClass);
    }

    private static class BlacklistedTypesConverter
    implements Converter {
        private BlacklistedTypesConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            throw new UnsupportedOperationException("Refusing to marshal " + source.getClass().getName() + " for security reasons");
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            throw new ConversionException("Refusing to unmarshal " + reader.getNodeName() + " for security reasons");
        }

        public boolean canConvert(Class type) {
            if (type == null) {
                return false;
            }
            try {
                ClassFilter.DEFAULT.check(type);
                ClassFilter.DEFAULT.check(type.getName());
            }
            catch (SecurityException se) {
                return true;
            }
            return false;
        }
    }

    class PluginClassOwnership
    implements ClassOwnership {
        private PluginManager pm;

        PluginClassOwnership() {
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public String ownerOf(Class<?> clazz) {
            Jenkins j;
            if (XStream2.this.classOwnership != null) {
                return XStream2.this.classOwnership.ownerOf(clazz);
            }
            if (this.pm == null && (j = Jenkins.getInstanceOrNull()) != null) {
                this.pm = j.getPluginManager();
            }
            if (this.pm == null) {
                return null;
            }
            PluginWrapper p = this.pm.whichPlugin(clazz);
            return p != null ? p.getShortName() + '@' + XStream2.trimVersion(p.getVersion()) : null;
        }
    }

    static interface ClassOwnership {
        @CheckForNull
        public String ownerOf(Class<?> var1);
    }

    public static abstract class PassthruConverter<T>
    implements Converter {
        private Converter converter;

        public PassthruConverter(XStream2 xstream) {
            this.converter = xstream.reflectionConverter;
        }

        public boolean canConvert(Class type) {
            return false;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            this.converter.marshal(source, writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Object obj = this.converter.unmarshal(reader, context);
            this.callback(obj, context);
            return obj;
        }

        protected abstract void callback(T var1, UnmarshallingContext var2);
    }

    private static final class AssociatedConverterImpl
    implements Converter {
        private final XStream xstream;
        private final ConcurrentHashMap<Class<?>, Converter> cache = new ConcurrentHashMap();

        private AssociatedConverterImpl(XStream xstream) {
            this.xstream = xstream;
        }

        private Converter findConverter(Class<?> t) {
            Converter result = this.cache.get(t);
            if (result != null) {
                return result == this ? null : result;
            }
            try {
                if (t == null || t.getClassLoader() == null) {
                    return null;
                }
                Class<?> cl = t.getClassLoader().loadClass(t.getName() + "$ConverterImpl");
                Constructor<?> c = cl.getConstructors()[0];
                Class<?>[] p = c.getParameterTypes();
                Object[] args = new Object[p.length];
                for (int i = 0; i < p.length; ++i) {
                    if (p[i] == XStream.class || p[i] == XStream2.class) {
                        args[i] = this.xstream;
                        continue;
                    }
                    if (p[i] == Mapper.class) {
                        args[i] = this.xstream.getMapper();
                        continue;
                    }
                    throw new InstantiationError("Unrecognized constructor parameter: " + p[i]);
                }
                ConverterMatcher cm = (ConverterMatcher)c.newInstance(args);
                result = cm instanceof SingleValueConverter ? new SingleValueConverterWrapper((SingleValueConverter)cm) : (Converter)cm;
                this.cache.put(t, result);
                return result;
            }
            catch (ClassNotFoundException e) {
                this.cache.put(t, this);
                return null;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
            catch (InstantiationException e) {
                InstantiationError x = new InstantiationError();
                x.initCause(e);
                throw x;
            }
            catch (InvocationTargetException e) {
                InstantiationError x = new InstantiationError();
                x.initCause(e);
                throw x;
            }
        }

        public boolean canConvert(Class type) {
            return this.findConverter(type) != null;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            this.findConverter(source.getClass()).marshal(source, writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return this.findConverter(context.getRequiredType()).unmarshal(reader, context);
        }
    }

    private class CompatibilityMapper
    extends MapperWrapper {
        private CompatibilityMapper(Mapper wrapped) {
            super(wrapped);
        }

        public Class realClass(String elementName) {
            Class s = (Class)XStream2.this.compatibilityAliases.get(elementName);
            if (s != null) {
                return s;
            }
            try {
                return super.realClass(elementName);
            }
            catch (CannotResolveClassException e) {
                if (elementName.indexOf(45) >= 0) {
                    try {
                        Class c = super.realClass(elementName.replace('-', '$'));
                        XStream2.this.oldData.set(Boolean.TRUE);
                        return c;
                    }
                    catch (CannotResolveClassException e2) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
    }

    final class MapperInjectionPoint
    extends MapperDelegate {
        public MapperInjectionPoint(Mapper wrapped) {
            super(wrapped);
        }

        public Mapper getDelegate() {
            return this.delegate;
        }

        public void setDelegate(Mapper m) {
            this.delegate = m;
        }
    }
}

