/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public class SequentialExecutionQueue
implements Executor {
    private final Map<Runnable, QueueEntry> entries = new HashMap<Runnable, QueueEntry>();
    private ExecutorService executors;
    private final Set<QueueEntry> inProgress = new HashSet<QueueEntry>();

    public SequentialExecutionQueue(ExecutorService executors) {
        this.executors = executors;
    }

    public synchronized ExecutorService getExecutors() {
        return this.executors;
    }

    public synchronized void setExecutors(ExecutorService svc) {
        ExecutorService old = this.executors;
        this.executors = svc;
        old.shutdown();
    }

    @Override
    public synchronized void execute(@Nonnull Runnable item) {
        QueueEntry e = this.entries.get(item);
        if (e == null) {
            e = new QueueEntry(item);
            this.entries.put(item, e);
            e.submit();
        } else {
            e.queued = true;
        }
    }

    public synchronized boolean isStarving(long threshold) {
        long now = System.currentTimeMillis();
        for (QueueEntry e : this.entries.values()) {
            if (now - e.submissionTime <= threshold) continue;
            return true;
        }
        return false;
    }

    public synchronized Set<Runnable> getInProgress() {
        HashSet<Runnable> items = new HashSet<Runnable>();
        for (QueueEntry entry : this.inProgress) {
            items.add(entry.item);
        }
        return items;
    }

    private final class QueueEntry
    implements Runnable {
        private final Runnable item;
        private boolean queued;
        private long submissionTime;

        private QueueEntry(Runnable item) {
            this.item = item;
            this.queued = true;
        }

        private void submit() {
            this.submissionTime = System.currentTimeMillis();
            SequentialExecutionQueue.this.executors.submit(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SequentialExecutionQueue sequentialExecutionQueue;
            try {
                sequentialExecutionQueue = SequentialExecutionQueue.this;
                synchronized (sequentialExecutionQueue) {
                    assert (this.queued);
                    this.queued = false;
                    SequentialExecutionQueue.this.inProgress.add(this);
                }
                this.item.run();
            }
            finally {
                sequentialExecutionQueue = SequentialExecutionQueue.this;
                synchronized (sequentialExecutionQueue) {
                    if (this.queued) {
                        this.submit();
                    } else {
                        SequentialExecutionQueue.this.entries.remove(this.item);
                    }
                    SequentialExecutionQueue.this.inProgress.remove(this);
                }
            }
        }
    }
}

