/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.trilead.ssh2.crypto.Base64;
import hudson.model.TaskListener;
import hudson.util.AtomicFileWriter;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.LinkOption;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.io.FileUtils;

public class SecretRewriter {
    private final Cipher cipher;
    private final SecretKey key;
    private int count;
    private final File backupDirectory;
    private Set<String> callstack = new HashSet<String>();
    private static final boolean[] IS_BASE64 = new boolean[128];

    public SecretRewriter(File backupDirectory) throws GeneralSecurityException {
        this.cipher = Secret.getCipher("AES");
        this.key = Secret.getLegacyKey();
        this.backupDirectory = backupDirectory;
    }

    private String tryRewrite(String s) throws IOException, InvalidKeyException {
        byte[] in;
        if (s.length() < 24) {
            return s;
        }
        if (!SecretRewriter.isBase64(s)) {
            return s;
        }
        try {
            in = Base64.decode((char[])s.toCharArray());
        }
        catch (IOException e) {
            return s;
        }
        this.cipher.init(2, this.key);
        Secret sec = Secret.tryDecrypt(this.cipher, in);
        if (sec != null) {
            return sec.getEncryptedValue();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rewrite(File f, File backup) throws InvalidKeyException, IOException {
        AtomicFileWriter w = new AtomicFileWriter(f, "UTF-8");
        try {
            boolean modified = false;
            try (PrintWriter out = new PrintWriter(new BufferedWriter(w));
                 FileInputStream fin = new FileInputStream(f);){
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fin, "UTF-8"));
                StringBuilder buf = new StringBuilder();
                while ((line = r.readLine()) != null) {
                    int eidx;
                    int sidx;
                    int copied = 0;
                    buf.setLength(0);
                    while ((sidx = line.indexOf(62, copied)) >= 0 && (eidx = line.indexOf(60, sidx)) >= 0) {
                        String elementText = line.substring(sidx + 1, eidx);
                        String replacement = this.tryRewrite(elementText);
                        if (!replacement.equals(elementText)) {
                            modified = true;
                        }
                        buf.append(line.substring(copied, sidx + 1));
                        buf.append(replacement);
                        copied = eidx;
                    }
                    buf.append(line.substring(copied));
                    out.println(buf.toString());
                }
            }
            if (modified) {
                if (backup != null) {
                    backup.getParentFile().mkdirs();
                    FileUtils.copyFile((File)f, (File)backup);
                }
                w.commit();
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            w.abort();
        }
    }

    public synchronized int rewriteRecursive(File dir, TaskListener listener) throws InvalidKeyException {
        return this.rewriteRecursive(dir, "", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rewriteRecursive(File dir, String relative, TaskListener listener) throws InvalidKeyException {
        String canonical;
        try {
            canonical = dir.toPath().toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            canonical = dir.getAbsolutePath();
        }
        if (!this.callstack.add(canonical)) {
            listener.getLogger().println("Cycle detected: " + dir);
            return 0;
        }
        try {
            File[] children = dir.listFiles();
            if (children == null) {
                int n = 0;
                return n;
            }
            int rewritten = 0;
            for (File child : children) {
                String cn = child.getName();
                if (cn.endsWith(".xml")) {
                    if (this.count++ % 100 == 0) {
                        listener.getLogger().println("Scanning " + child);
                    }
                    try {
                        File backup = null;
                        if (this.backupDirectory != null) {
                            backup = new File(this.backupDirectory, relative + '/' + cn);
                        }
                        if (this.rewrite(child, backup)) {
                            if (backup != null) {
                                listener.getLogger().println("Copied " + child + " to " + backup + " as a backup");
                            }
                            listener.getLogger().println("Rewritten " + child);
                            ++rewritten;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace(listener.error("Failed to rewrite " + child));
                    }
                }
                if (!child.isDirectory() || this.isIgnoredDir(child)) continue;
                rewritten += this.rewriteRecursive(child, relative.length() == 0 ? cn : relative + '/' + cn, listener);
            }
            int n = rewritten;
            return n;
        }
        finally {
            this.callstack.remove(canonical);
        }
    }

    protected boolean isIgnoredDir(File dir) {
        String n = dir.getName();
        return n.equals("workspace") || n.equals("artifacts") || n.equals("plugins") || n.equals("jenkins.security.RekeySecretAdminMonitor") || n.equals(".") || n.equals("..");
    }

    private static boolean isBase64(char ch) {
        return '\u0000' <= ch && ch < '\u0080' && IS_BASE64[ch];
    }

    private static boolean isBase64(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (SecretRewriter.isBase64(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        for (int i = 0; i < chars.length(); ++i) {
            SecretRewriter.IS_BASE64[chars.charAt((int)i)] = true;
        }
    }
}

