/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MaskingClassLoader
extends ClassLoader {
    private final List<String> masksClasses = new CopyOnWriteArrayList<String>();
    private final List<String> masksResources = new CopyOnWriteArrayList<String>();

    public MaskingClassLoader(ClassLoader parent, String ... masks) {
        this(parent, Arrays.asList(masks));
    }

    public MaskingClassLoader(ClassLoader parent, Collection<String> masks) {
        super(parent);
        this.masksClasses.addAll(masks);
        for (String mask : masks) {
            this.masksResources.add(mask.replace(".", "/"));
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String mask : this.masksClasses) {
            if (!name.startsWith(mask)) continue;
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        if (this.isMasked(name)) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isMasked(name)) {
            return Collections.emptyEnumeration();
        }
        return super.getResources(name);
    }

    public void add(String prefix) {
        this.masksClasses.add(prefix);
        if (prefix != null) {
            this.masksResources.add(prefix.replace(".", "/"));
        }
    }

    private boolean isMasked(String name) {
        for (String mask : this.masksResources) {
            if (!name.startsWith(mask)) continue;
            return true;
        }
        return false;
    }
}

