/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.util.RobustReflectionConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jenkins.util.xstream.CriticalXStreamException;

public class CopyOnWriteList<E>
implements Iterable<E> {
    private volatile List<? extends E> core;

    public CopyOnWriteList(List<E> core) {
        this(core, false);
    }

    private CopyOnWriteList(List<E> core, boolean noCopy) {
        this.core = noCopy ? core : new ArrayList(core);
    }

    public CopyOnWriteList() {
        this.core = Collections.emptyList();
    }

    public synchronized void add(E e) {
        ArrayList<E> n = new ArrayList<E>(this.core);
        n.add(e);
        this.core = n;
    }

    public synchronized void addAll(Collection<? extends E> items) {
        ArrayList<? extends E> n = new ArrayList<E>(this.core);
        n.addAll(items);
        this.core = n;
    }

    public synchronized boolean remove(E e) {
        ArrayList<E> n = new ArrayList<E>(this.core);
        boolean r = n.remove(e);
        this.core = n;
        return r;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<? extends E> itr = this.core.iterator();
        return new Iterator<E>(){
            private E last;

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public E next() {
                this.last = itr.next();
                return this.last;
            }

            @Override
            public void remove() {
                CopyOnWriteList.this.remove(this.last);
            }
        };
    }

    public void replaceBy(CopyOnWriteList<? extends E> that) {
        this.core = that.core;
    }

    public void replaceBy(Collection<? extends E> that) {
        this.core = new ArrayList<E>(that);
    }

    public void replaceBy(E ... that) {
        this.replaceBy((Collection<? extends E>)Arrays.asList(that));
    }

    public void clear() {
        this.core = new ArrayList<E>();
    }

    public <E> E[] toArray(E[] array) {
        return this.core.toArray(array);
    }

    public List<E> getView() {
        return Collections.unmodifiableList(this.core);
    }

    public void addAllTo(Collection<? super E> dst) {
        dst.addAll(this.core);
    }

    public E get(int index) {
        return this.core.get(index);
    }

    public boolean isEmpty() {
        return this.core.isEmpty();
    }

    public int size() {
        return this.core.size();
    }

    public boolean contains(Object item) {
        return this.core.contains(item);
    }

    public String toString() {
        return this.core.toString();
    }

    public static final class ConverterImpl
    extends AbstractCollectionConverter {
        public ConverterImpl(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return type == CopyOnWriteList.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            for (Object o : (CopyOnWriteList)source) {
                this.writeItem(o, context, writer);
            }
        }

        public CopyOnWriteList unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            ArrayList<Object> items = new ArrayList<Object>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                try {
                    Object item = this.readItem(reader, context, items);
                    items.add(item);
                }
                catch (CriticalXStreamException e) {
                    throw e;
                }
                catch (XStreamException e) {
                    RobustReflectionConverter.addErrorInContext(context, e);
                }
                catch (LinkageError e) {
                    RobustReflectionConverter.addErrorInContext(context, e);
                }
                reader.moveUp();
            }
            return new CopyOnWriteList(items, true);
        }
    }
}

