/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import hudson.Extension;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.InstallSourceProperty;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolLocationTranslator;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;

@Extension
public class InstallerTranslator
extends ToolLocationTranslator {
    private static final Map<Node, Map<ToolInstallation, Semaphore>> mutexByNode = new WeakHashMap<Node, Map<ToolInstallation, Semaphore>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolHome(Node node, ToolInstallation tool, TaskListener log) throws IOException, InterruptedException {
        if (node.getRootPath() == null) {
            log.error(node.getDisplayName() + " is offline; cannot locate " + tool.getName());
            return null;
        }
        InstallSourceProperty isp = (InstallSourceProperty)tool.getProperties().get(InstallSourceProperty.class);
        if (isp == null) {
            return null;
        }
        for (ToolInstaller installer : isp.installers) {
            Semaphore semaphore;
            if (!installer.appliesTo(node)) continue;
            Object object = mutexByNode;
            synchronized (object) {
                Map<ToolInstallation, Semaphore> mutexByTool = mutexByNode.get(node);
                if (mutexByTool == null) {
                    mutexByTool = new WeakHashMap<ToolInstallation, Semaphore>();
                    mutexByNode.put(node, mutexByTool);
                }
                if ((semaphore = mutexByTool.get(tool)) == null) {
                    semaphore = new Semaphore(1);
                    mutexByTool.put(tool, semaphore);
                }
            }
            semaphore.acquire();
            try {
                object = installer.performInstallation(tool, node, log).getRemote();
                return object;
            }
            finally {
                semaphore.release();
            }
        }
        return null;
    }
}

