/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class BuildTrigger
extends Recorder
implements DependencyDeclarer {
    private String childProjects;
    private final Result threshold;
    private static final Logger LOGGER = Logger.getLogger(BuildTrigger.class.getName());

    public BuildTrigger(String childProjects, boolean evenIfUnstable) {
        this(childProjects, evenIfUnstable ? Result.UNSTABLE : Result.SUCCESS);
    }

    @DataBoundConstructor
    public BuildTrigger(String childProjects, String threshold) {
        this(childProjects, Result.fromString(StringUtils.defaultString((String)threshold, (String)Result.SUCCESS.toString())));
    }

    public BuildTrigger(String childProjects, Result threshold) {
        if (childProjects == null) {
            throw new IllegalArgumentException();
        }
        this.childProjects = childProjects;
        this.threshold = threshold;
    }

    public BuildTrigger(List<AbstractProject> childProjects, Result threshold) {
        this((Collection<? extends AbstractProject>)childProjects, threshold);
    }

    public BuildTrigger(Collection<? extends AbstractProject> childProjects, Result threshold) {
        this(Items.toNameList(childProjects), threshold);
    }

    public String getChildProjectsValue() {
        return this.childProjects;
    }

    public Result getThreshold() {
        if (this.threshold == null) {
            return Result.SUCCESS;
        }
        return this.threshold;
    }

    @Deprecated
    public List<AbstractProject> getChildProjects() {
        return this.getChildProjects(Jenkins.getInstance());
    }

    public List<AbstractProject> getChildProjects(AbstractProject owner) {
        return this.getChildProjects(owner == null ? null : owner.getParent());
    }

    public List<AbstractProject> getChildProjects(ItemGroup base) {
        return Items.fromNameList(base, this.childProjects, AbstractProject.class);
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean hasSame(AbstractProject owner, Collection<? extends AbstractProject> projects) {
        List<AbstractProject> children = this.getChildProjects(owner);
        return children.size() == projects.size() && children.containsAll(projects);
    }

    @Deprecated
    public boolean hasSame(Collection<? extends AbstractProject> projects) {
        return this.hasSame(null, projects);
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        return true;
    }

    @Deprecated
    public static boolean execute(AbstractBuild build, BuildListener listener, BuildTrigger trigger) {
        return BuildTrigger.execute(build, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(AbstractBuild build, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        final DependencyGraph graph = Jenkins.getInstance().getDependencyGraph();
        ArrayList<DependencyGraph.Dependency> downstreamProjects = new ArrayList<DependencyGraph.Dependency>(graph.getDownstreamDependencies((AbstractProject)build.getProject()));
        Collections.sort(downstreamProjects, new Comparator<DependencyGraph.Dependency>(){

            @Override
            public int compare(DependencyGraph.Dependency lhs, DependencyGraph.Dependency rhs) {
                return graph.compare(rhs.getDownstreamProject(), lhs.getDownstreamProject());
            }
        });
        Authentication auth = Jenkins.getAuthentication();
        if (auth.equals(ACL.SYSTEM)) {
            if (QueueItemAuthenticatorDescriptor.all().isEmpty()) {
                if (downstreamProjects.isEmpty()) {
                    return true;
                }
                logger.println(Messages.BuildTrigger_warning_you_have_no_plugins_providing_ac());
            } else if (QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty()) {
                if (downstreamProjects.isEmpty()) {
                    return true;
                }
                logger.println(Messages.BuildTrigger_warning_access_control_for_builds_in_glo());
            } else {
                logger.println(Messages.BuildTrigger_warning_this_build_has_no_associated_aut());
                auth = Jenkins.ANONYMOUS;
            }
        }
        for (DependencyGraph.Dependency dep : downstreamProjects) {
            ArrayList<Action> buildActions = new ArrayList<Action>();
            SecurityContext orig = ACL.impersonate(auth);
            try {
                if (!dep.shouldTriggerBuild(build, listener, buildActions)) continue;
                AbstractProject p = dep.getDownstreamProject();
                if (p.isDisabled()) {
                    logger.println(Messages.BuildTrigger_Disabled(ModelHyperlinkNote.encodeTo(p)));
                    continue;
                }
                boolean scheduled = p.scheduleBuild(p.getQuietPeriod(), new Cause.UpstreamCause(build), buildActions.toArray(new Action[buildActions.size()]));
                if (Jenkins.getInstance().getItemByFullName(p.getFullName()) != p) continue;
                String name = ModelHyperlinkNote.encodeTo(p);
                if (scheduled) {
                    logger.println(Messages.BuildTrigger_Triggering(name));
                    continue;
                }
                logger.println(Messages.BuildTrigger_InQueue(name));
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)orig);
            }
        }
        return true;
    }

    @Override
    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        for (AbstractProject p : this.getChildProjects(owner)) {
            graph.addDependency(new DependencyGraph.Dependency(owner, p){

                @Override
                public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                    AbstractProject downstream = this.getDownstreamProject();
                    if (Jenkins.getInstance().getItemByFullName(downstream.getFullName()) != downstream) {
                        LOGGER.log(Level.WARNING, "Running as {0} cannot even see {1} for trigger from {2}", new Object[]{Jenkins.getAuthentication().getName(), downstream, this.getUpstreamProject()});
                        return false;
                    }
                    if (!downstream.hasPermission(Item.BUILD)) {
                        listener.getLogger().println(Messages.BuildTrigger_you_have_no_permission_to_build_(ModelHyperlinkNote.encodeTo(downstream)));
                        return false;
                    }
                    return build.getResult().isBetterOrEqualTo(BuildTrigger.this.threshold);
                }
            });
        }
    }

    @Override
    public boolean needsToRunAfterFinalized() {
        return true;
    }

    @Deprecated
    public boolean onJobRenamed(String oldName, String newName) {
        if (!this.childProjects.contains(oldName)) {
            return false;
        }
        boolean changed = false;
        String[] projects = this.childProjects.split(",");
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].trim().equals(oldName)) continue;
            projects[i] = newName;
            changed = true;
        }
        if (changed) {
            StringBuilder b = new StringBuilder();
            for (String p : projects) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(p);
            }
            this.childProjects = b.toString();
        }
        return changed;
    }

    private Object readResolve() {
        if (this.childProjects == null) {
            this.childProjects = "";
            return "";
        }
        return this;
    }

    @Extension
    @Symbol(value={"downstream"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Override
        public String getDisplayName() {
            return Messages.BuildTrigger_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/project-config/downstream.html";
        }

        @Override
        public BuildTrigger newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String childProjectsString = formData.getString("childProjects").trim();
            if (childProjectsString.endsWith(",")) {
                childProjectsString = childProjectsString.substring(0, childProjectsString.length() - 1).trim();
            }
            return new BuildTrigger(childProjectsString, formData.optString("threshold", Result.SUCCESS.toString()));
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean showEvenIfUnstableOption(@CheckForNull Class<? extends AbstractProject<?, ?>> jobType) {
            return jobType == null || !jobType.getName().contains("PromotionProcess");
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            if (project == null) {
                return FormValidation.ok(Messages.BuildTrigger_ok_ancestor_is_null());
            }
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull(value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (!StringUtils.isNotBlank((String)projectName)) continue;
                Item item = Jenkins.getInstance().getItem(projectName, project, Item.class);
                if (item == null) {
                    AbstractProject nearest = AbstractProject.findNearest(projectName, project.getParent());
                    String alternative = nearest != null ? nearest.getRelativeNameFrom(project) : "?";
                    return FormValidation.error(Messages.BuildTrigger_NoSuchProject(projectName, alternative));
                }
                if (!(item instanceof AbstractProject)) {
                    return FormValidation.error(Messages.BuildTrigger_NotBuildable(projectName));
                }
                Authentication auth = Tasks.getAuthenticationOf(project);
                if (auth.equals(ACL.SYSTEM) && !QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty()) {
                    auth = Jenkins.ANONYMOUS;
                }
                if (!item.getACL().hasPermission(auth, Item.BUILD)) {
                    return FormValidation.error(Messages.BuildTrigger_you_have_no_permission_to_build_(projectName));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error(Messages.BuildTrigger_NoProjectSpecified());
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteChildProjects(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
            return AutoCompletionCandidates.ofJobNames(Job.class, value, self, container);
        }

        @Extension
        public static class ItemListenerImpl
        extends ItemListener {
            @Override
            public void onLocationChanged(Item item, String oldFullName, String newFullName) {
                try (ACLContext _ = ACL.as(ACL.SYSTEM);){
                    this.locationChanged(item, oldFullName, newFullName);
                }
            }

            private void locationChanged(Item item, String oldFullName, String newFullName) {
                for (Project p : Jenkins.getInstance().getAllItems(Project.class)) {
                    String cp2;
                    BuildTrigger t = (BuildTrigger)p.getPublishersList().get(BuildTrigger.class);
                    if (t == null || (cp2 = Items.computeRelativeNamesAfterRenaming(oldFullName, newFullName, t.childProjects, p.getParent())).equals(t.childProjects)) continue;
                    t.childProjects = cp2;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldFullName + " to " + newFullName, e);
                    }
                }
            }
        }
    }
}

