/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.Messages;
import hudson.slaves.OfflineCause;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.SlaveToMasterCallable;
import jenkins.util.SystemProperties;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"connectionActivityMonitor"})
public class ConnectionActivityMonitor
extends AsyncPeriodicWork {
    private static final long TIME_TILL_PING = SystemProperties.getLong(ConnectionActivityMonitor.class.getName() + ".timeToPing", TimeUnit2.MINUTES.toMillis(3L));
    private static final long FREQUENCY = SystemProperties.getLong(ConnectionActivityMonitor.class.getName() + ".frequency", TimeUnit2.SECONDS.toMillis(10L));
    private static final long TIMEOUT = SystemProperties.getLong(ConnectionActivityMonitor.class.getName() + ".timeToPing", TimeUnit2.MINUTES.toMillis(4L));
    public boolean enabled = SystemProperties.getBoolean(ConnectionActivityMonitor.class.getName() + ".enabled");
    private static final PingCommand PING_COMMAND = new PingCommand();
    private static final Logger LOGGER = Logger.getLogger(ConnectionActivityMonitor.class.getName());

    public ConnectionActivityMonitor() {
        super("Connection Activity monitoring to agents");
    }

    @Override
    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        if (!this.enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        for (Computer c : Jenkins.getInstance().getComputers()) {
            VirtualChannel ch = c.getChannel();
            if (!(ch instanceof Channel)) continue;
            Channel channel = (Channel)ch;
            if (now - channel.getLastHeard() > TIME_TILL_PING) {
                Long lastPing = (Long)channel.getProperty(ConnectionActivityMonitor.class);
                if (lastPing != null && now - lastPing > TIMEOUT) {
                    LOGGER.info("Repeated ping attempts failed on " + c.getName() + ". Disconnecting");
                    c.disconnect(OfflineCause.create(Messages._ConnectionActivityMonitor_OfflineCause()));
                    continue;
                }
                channel.callAsync(PING_COMMAND);
                if (lastPing != null) continue;
                channel.setProperty(ConnectionActivityMonitor.class, (Object)now);
                continue;
            }
            channel.setProperty(ConnectionActivityMonitor.class, null);
        }
    }

    @Override
    public long getRecurrencePeriod() {
        return this.enabled ? FREQUENCY : TimeUnit2.DAYS.toMillis(30L);
    }

    private static final class PingCommand
    extends SlaveToMasterCallable<Void, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private PingCommand() {
        }

        @Override
        public Void call() throws RuntimeException {
            return null;
        }
    }
}

