/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.PingThread;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.PingFailureAnalyzer;
import jenkins.util.SystemProperties;

@Extension
public class ChannelPinger
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(ChannelPinger.class.getName());
    private static final String SYS_PROPERTY_NAME = ChannelPinger.class.getName() + ".pingInterval";
    private static final int DEFAULT_PING_INTERVAL_MIN = 5;
    private final int pingInterval = SystemProperties.getInteger(SYS_PROPERTY_NAME, 5);

    @Override
    public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) {
        this.install(channel);
    }

    public void install(Channel channel) {
        if (this.pingInterval < 1) {
            LOGGER.fine("Agent ping is disabled");
            return;
        }
        try {
            channel.call(new SetUpRemotePing(this.pingInterval));
            LOGGER.fine("Set up a remote ping for " + channel.getName());
        }
        catch (Exception e) {
            LOGGER.severe("Failed to set up a ping for " + channel.getName());
        }
        ChannelPinger.setUpPingForChannel(channel, this.pingInterval, true);
    }

    private static void setUpPingForChannel(final Channel channel, int interval, final boolean analysis) {
        LOGGER.log(Level.FINE, "setting up ping on {0} at interval {1}m", new Object[]{channel.getName(), interval});
        final AtomicBoolean isInClosed = new AtomicBoolean(false);
        final PingThread t = new PingThread(channel, interval * 60 * 1000){

            @Override
            protected void onDead(Throwable cause) {
                try {
                    if (analysis) {
                        this.analyze(cause);
                    }
                    if (isInClosed.get()) {
                        LOGGER.log(Level.FINE, "Ping failed after the channel " + channel.getName() + " is already partially closed.", cause);
                    } else {
                        LOGGER.log(Level.INFO, "Ping failed. Terminating the channel " + channel.getName() + ".", cause);
                        channel.close(cause);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to terminate the channel " + channel.getName(), e);
                }
            }

            private void analyze(Throwable cause) throws IOException {
                for (PingFailureAnalyzer pfa : PingFailureAnalyzer.all()) {
                    pfa.onPingFailure(channel, cause);
                }
            }

            @Override
            @Deprecated
            protected void onDead() {
                this.onDead(null);
            }
        };
        channel.addListener(new Channel.Listener(){

            @Override
            public void onClosed(Channel channel, IOException cause) {
                LOGGER.fine("Terminating ping thread for " + channel.getName());
                isInClosed.set(true);
                t.interrupt();
            }
        });
        t.start();
        LOGGER.fine("Ping thread started for " + channel + " with a " + interval + " minute interval");
    }

    private static class SetUpRemotePing
    extends MasterToSlaveCallable<Void, IOException> {
        private static final long serialVersionUID = -2702219700841759872L;
        private int pingInterval;

        public SetUpRemotePing(int pingInterval) {
            this.pingInterval = pingInterval;
        }

        @Override
        public Void call() throws IOException {
            ChannelPinger.setUpPingForChannel(Channel.current(), this.pingInterval, false);
            return null;
        }
    }
}

