/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import groovy.lang.Binding;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.ContainerAuthentication;
import hudson.security.Messages;
import hudson.security.SecurityRealm;
import hudson.util.spring.BeanBuilder;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.web.context.WebApplicationContext;

public final class LegacySecurityRealm
extends SecurityRealm
implements AuthenticationManager {
    @Restricted(value={NoExternalUse.class})
    public static Descriptor<SecurityRealm> DESCRIPTOR;

    @Override
    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(this);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof ContainerAuthentication) {
            return authentication;
        }
        return null;
    }

    @Override
    public String getAuthenticationGatewayUrl() {
        return "j_security_check";
    }

    @Override
    public String getLoginUrl() {
        return "loginEntry";
    }

    @Override
    public Filter createFilter(FilterConfig filterConfig) {
        Binding binding = new Binding();
        SecurityRealm.SecurityComponents sc = this.createSecurityComponents();
        binding.setVariable("securityComponents", (Object)sc);
        binding.setVariable("securityRealm", (Object)this);
        BeanBuilder builder = new BeanBuilder();
        builder.parse(filterConfig.getServletContext().getResourceAsStream("/WEB-INF/security/SecurityFilters.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return (Filter)context.getBean("legacy");
    }

    @Extension
    @Symbol(value={"legacy"})
    public static class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        public SecurityRealm newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new LegacySecurityRealm();
        }

        @Override
        public String getDisplayName() {
            return Messages.LegacySecurityRealm_Displayname();
        }
    }
}

