/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.google.common.base.Predicate;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Functions;
import hudson.markup.MarkupFormatter;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.security.AuthorizationStrategy;
import hudson.security.Messages;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.util.FormApply;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.util.ServerTcpPort;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension(ordinal=2.147483437E9)
@Symbol(value={"securityConfig"})
public class GlobalSecurityConfiguration
extends ManagementLink
implements Describable<GlobalSecurityConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(GlobalSecurityConfiguration.class.getName());
    public static Predicate<GlobalConfigurationCategory> FILTER = new Predicate<GlobalConfigurationCategory>(){

        public boolean apply(GlobalConfigurationCategory input) {
            return input instanceof GlobalConfigurationCategory.Security;
        }
    };

    public MarkupFormatter getMarkupFormatter() {
        return Jenkins.getInstance().getMarkupFormatter();
    }

    public int getSlaveAgentPort() {
        return Jenkins.getInstance().getSlaveAgentPort();
    }

    @Restricted(value={DoNotUse.class})
    public boolean isSlaveAgentPortEnforced() {
        return Jenkins.getInstance().isSlaveAgentPortEnforced();
    }

    public Set<String> getAgentProtocols() {
        return Jenkins.getInstance().getAgentProtocols();
    }

    public boolean isDisableRememberMe() {
        return Jenkins.getInstance().isDisableRememberMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doConfigure(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        BulkChange bc = new BulkChange(Jenkins.getInstance());
        try {
            boolean result = this.configure(req, req.getSubmittedForm());
            LOGGER.log(Level.FINE, "security saved: " + result);
            Jenkins.getInstance().save();
            FormApply.success(req.getContextPath() + "/manage").generateResponse(req, rsp, null);
        }
        finally {
            bc.commit();
        }
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        Jenkins j = Jenkins.getInstance();
        j.checkPermission(Jenkins.ADMINISTER);
        if (json.has("useSecurity")) {
            JSONObject security = json.getJSONObject("useSecurity");
            j.setDisableRememberMe(security.optBoolean("disableRememberMe", false));
            j.setSecurityRealm(SecurityRealm.all().newInstanceFromRadioList(security, "realm"));
            j.setAuthorizationStrategy(AuthorizationStrategy.all().newInstanceFromRadioList(security, "authorization"));
            try {
                j.setSlaveAgentPort(new ServerTcpPort(security.getJSONObject("slaveAgentPort")).getPort());
            }
            catch (IOException e) {
                throw new Descriptor.FormException(e, "slaveAgentPortType");
            }
            TreeSet<String> agentProtocols = new TreeSet<String>();
            if (security.has("agentProtocol")) {
                Object protocols = security.get("agentProtocol");
                if (protocols instanceof JSONArray) {
                    for (int i = 0; i < ((JSONArray)protocols).size(); ++i) {
                        agentProtocols.add(((JSONArray)protocols).getString(i));
                    }
                } else {
                    agentProtocols.add(protocols.toString());
                }
            }
            j.setAgentProtocols(agentProtocols);
        } else {
            j.disableSecurity();
        }
        if (json.has("markupFormatter")) {
            j.setMarkupFormatter((MarkupFormatter)req.bindJSON(MarkupFormatter.class, json.getJSONObject("markupFormatter")));
        } else {
            j.setMarkupFormatter(null);
        }
        boolean result = true;
        for (Descriptor d : Functions.getSortedDescriptorsForGlobalConfig(FILTER)) {
            result &= this.configureDescriptor(req, json, d);
        }
        return result;
    }

    private boolean configureDescriptor(StaplerRequest req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        String name = d.getJsonSafeClassName();
        JSONObject js = json.has(name) ? json.getJSONObject(name) : new JSONObject();
        json.putAll((Map)js);
        return d.configure(req, js);
    }

    @Override
    public String getDisplayName() {
        return this.getDescriptor().getDisplayName();
    }

    @Override
    public String getDescription() {
        return Messages.GlobalSecurityConfiguration_Description();
    }

    @Override
    public String getIconFileName() {
        return "secure.png";
    }

    @Override
    public String getUrlName() {
        return "configureSecurity";
    }

    @Override
    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    @Override
    public Descriptor<GlobalSecurityConfiguration> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    @Extension
    @Symbol(value={"security"})
    public static final class DescriptorImpl
    extends Descriptor<GlobalSecurityConfiguration> {
        @Override
        public String getDisplayName() {
            return Messages.GlobalSecurityConfiguration_DisplayName();
        }
    }
}

