/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.model.Computer;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;

public abstract class AbstractAsyncNodeMonitorDescriptor<T>
extends AbstractNodeMonitorDescriptor<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractAsyncNodeMonitorDescriptor.class.getName());

    protected AbstractAsyncNodeMonitorDescriptor() {
    }

    protected AbstractAsyncNodeMonitorDescriptor(long interval) {
        super(interval);
    }

    protected AbstractAsyncNodeMonitorDescriptor(Class<? extends NodeMonitor> clazz) {
        super(clazz);
    }

    protected AbstractAsyncNodeMonitorDescriptor(Class<? extends NodeMonitor> clazz, long interval) {
        super(clazz, interval);
    }

    @CheckForNull
    protected abstract Callable<T, IOException> createCallable(Computer var1);

    @Override
    protected T monitor(Computer c) throws IOException, InterruptedException {
        Callable<T, IOException> cc;
        VirtualChannel ch = c.getChannel();
        if (ch != null && (cc = this.createCallable(c)) != null) {
            return ch.call(cc);
        }
        return null;
    }

    @Override
    protected Map<Computer, T> monitor() throws InterruptedException {
        HashMap<Computer, Future<T>> futures = new HashMap<Computer, Future<T>>();
        for (Computer c : Jenkins.getInstance().getComputers()) {
            try {
                Callable<T, IOException> cc;
                VirtualChannel ch = c.getChannel();
                futures.put(c, null);
                if (ch == null || (cc = this.createCallable(c)) == null) continue;
                futures.put(c, ch.callAsync(cc));
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Failed to monitor " + c.getDisplayName() + " for " + this.getDisplayName(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to monitor " + c.getDisplayName() + " for " + this.getDisplayName(), e);
            }
        }
        long now = System.currentTimeMillis();
        long end = now + this.getMonitoringTimeOut();
        HashMap data = new HashMap();
        for (Map.Entry e : futures.entrySet()) {
            Computer c = (Computer)e.getKey();
            java.util.concurrent.Future f = (java.util.concurrent.Future)futures.get(c);
            data.put(c, null);
            if (f == null) continue;
            try {
                data.put(c, f.get(Math.max(0L, end - System.currentTimeMillis()), TimeUnit.MILLISECONDS));
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.WARNING, "Failed to monitor " + c.getDisplayName() + " for " + this.getDisplayName(), x);
            }
            catch (ExecutionException x) {
                LOGGER.log(Level.WARNING, "Failed to monitor " + c.getDisplayName() + " for " + this.getDisplayName(), x);
            }
            catch (TimeoutException x) {
                LOGGER.log(Level.WARNING, "Failed to monitor " + c.getDisplayName() + " for " + this.getDisplayName(), x);
            }
        }
        return data;
    }
}

