/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class StringParameterDefinition
extends SimpleParameterDefinition {
    private String defaultValue;

    @DataBoundConstructor
    public StringParameterDefinition(String name, String defaultValue, String description) {
        super(name, description);
        this.defaultValue = defaultValue;
    }

    public StringParameterDefinition(String name, String defaultValue) {
        this(name, defaultValue, null);
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof StringParameterValue) {
            StringParameterValue value = (StringParameterValue)defaultValue;
            return new StringParameterDefinition(this.getName(), value.value, this.getDescription());
        }
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public StringParameterValue getDefaultParameterValue() {
        StringParameterValue v = new StringParameterValue(this.getName(), this.defaultValue, this.getDescription());
        return v;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public ParameterValue createValue(String value) {
        return new StringParameterValue(this.getName(), value, this.getDescription());
    }

    @Extension
    @Symbol(value={"string", "stringParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.StringParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/string.html";
        }
    }
}

