/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.jcraft.jzlib.GZIPInputStream;
import com.thoughtworks.xstream.XStream;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FeedAdapter;
import hudson.Functions;
import hudson.Util;
import hudson.XmlFile;
import hudson.cli.declarative.CLIMethod;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleLogFilter;
import hudson.console.ConsoleNote;
import hudson.console.ModelHyperlinkNote;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.BallColor;
import hudson.model.BuildBadgeAction;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.CheckPoint;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.EnvironmentContributor;
import hudson.model.Executor;
import hudson.model.FreeStyleBuild;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.PermalinkProjectAction;
import hudson.model.PersistenceRoot;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.ResultTrend;
import hudson.model.Run;
import hudson.model.RunAction;
import hudson.model.RunnerStack;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.TransientBuildActionFactory;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SaveableListener;
import hudson.search.SearchIndexBuilder;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.tasks.BuildWrapper;
import hudson.util.FormApply;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import hudson.util.XStream2;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.ArtifactManager;
import jenkins.model.ArtifactManagerConfiguration;
import jenkins.model.ArtifactManagerFactory;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.model.RunAction2;
import jenkins.model.StandardArtifactManager;
import jenkins.model.lazy.BuildReference;
import jenkins.util.SystemProperties;
import jenkins.util.VirtualFile;
import jenkins.util.io.OnMaster;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public abstract class Run<JobT extends Job<JobT, RunT>, RunT extends Run<JobT, RunT>>
extends Actionable
implements ExtensionPoint,
Comparable<RunT>,
AccessControlled,
PersistenceRoot,
DescriptorByNameOwner,
OnMaster {
    public static final long QUEUE_ID_UNKNOWN = -1L;
    @Nonnull
    protected final transient JobT project;
    public transient int number;
    private long queueId = -1L;
    @Restricted(value={NoExternalUse.class})
    protected volatile transient RunT previousBuild;
    @Restricted(value={NoExternalUse.class})
    protected volatile transient RunT nextBuild;
    volatile transient RunT previousBuildInProgress;
    @CheckForNull
    private String id;
    protected long timestamp;
    private long startTime;
    protected volatile Result result;
    protected volatile String description;
    private volatile String displayName;
    private volatile transient State state;
    protected long duration;
    protected String charset;
    private boolean keepLog;
    private volatile transient RunExecution runner;
    @CheckForNull
    private ArtifactManager artifactManager;
    public static final int LIST_CUTOFF = Integer.parseInt(SystemProperties.getString("hudson.model.Run.ArtifactList.listCutoff", "16"));
    public static final int TREE_CUTOFF = Integer.parseInt(SystemProperties.getString("hudson.model.Run.ArtifactList.treeCutoff", "40"));
    public static final XStream XSTREAM = new XStream2();
    public static final XStream2 XSTREAM2 = (XStream2)XSTREAM;
    private static final Logger LOGGER;
    public static final Comparator<Run> ORDER_BY_DATE;
    public static final FeedAdapter<Run> FEED_ADAPTER;
    public static final FeedAdapter<Run> FEED_ADAPTER_LATEST;
    public static final PermissionGroup PERMISSIONS;
    public static final Permission DELETE;
    public static final Permission UPDATE;
    public static final Permission ARTIFACTS;

    protected Run(@Nonnull JobT job) throws IOException {
        this(job, System.currentTimeMillis());
        this.number = ((Job)this.project).assignBuildNumber();
        LOGGER.log(Level.FINER, "new {0} @{1}", new Object[]{this, this.hashCode()});
    }

    protected Run(@Nonnull JobT job, @Nonnull Calendar timestamp) {
        this(job, timestamp.getTimeInMillis());
    }

    protected Run(@Nonnull JobT job, long timestamp) {
        this.project = job;
        this.timestamp = timestamp;
        this.state = State.NOT_STARTED;
    }

    protected Run(@Nonnull JobT project, @Nonnull File buildDir) throws IOException {
        this.project = project;
        this.previousBuildInProgress = this._this();
        this.number = Integer.parseInt(buildDir.getName());
        this.reload();
    }

    public void reload() throws IOException {
        this.state = State.COMPLETED;
        this.result = Result.FAILURE;
        this.getDataFile().unmarshal(this);
        if (this.state == State.COMPLETED) {
            LOGGER.log(Level.FINER, "reload {0} @{1}", new Object[]{this, this.hashCode()});
        } else {
            LOGGER.log(Level.WARNING, "reload {0} @{1} with anomalous state {2}", new Object[]{this, this.hashCode(), this.state});
        }
    }

    protected void onLoad() {
        for (Action action : this.getAllActions()) {
            if (action instanceof RunAction2) {
                try {
                    ((RunAction2)action).onLoad(this);
                }
                catch (RuntimeException x) {
                    LOGGER.log(Level.WARNING, "failed to load " + action + " from " + this.getDataFile(), x);
                    this.getActions().remove(action);
                }
                continue;
            }
            if (!(action instanceof RunAction)) continue;
            ((RunAction)action).onLoad();
        }
        if (this.artifactManager != null) {
            this.artifactManager.onLoad(this);
        }
    }

    @Deprecated
    public List<Action> getTransientActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (TransientBuildActionFactory factory : TransientBuildActionFactory.all()) {
            for (Action action : factory.createFor(this)) {
                if (action == null) {
                    LOGGER.log(Level.WARNING, "null action added by {0}", factory);
                    continue;
                }
                actions.add(action);
            }
        }
        return Collections.unmodifiableList(actions);
    }

    @Override
    public void addAction(@Nonnull Action a) {
        super.addAction(a);
        if (a instanceof RunAction2) {
            ((RunAction2)a).onAttached(this);
        } else if (a instanceof RunAction) {
            ((RunAction)a).onAttached(this);
        }
    }

    @Nonnull
    protected RunT _this() {
        return (RunT)this;
    }

    @Override
    public int compareTo(@Nonnull RunT that) {
        return this.number - ((Run)that).number;
    }

    @Exported
    public long getQueueId() {
        return this.queueId;
    }

    @Restricted(value={NoExternalUse.class})
    public void setQueueId(long queueId) {
        this.queueId = queueId;
    }

    @Exported
    @CheckForNull
    public Result getResult() {
        return this.result;
    }

    public void setResult(@Nonnull Result r) {
        if (this.state != State.BUILDING) {
            throw new IllegalStateException("cannot change build result while in " + (Object)((Object)this.state));
        }
        if (this.result == null || r.isWorseThan(this.result)) {
            this.result = r;
            LOGGER.log(Level.FINE, this + " in " + this.getRootDir() + ": result is set to " + r, LOGGER.isLoggable(Level.FINER) ? new Exception() : null);
        }
    }

    @Nonnull
    public List<BuildBadgeAction> getBadgeActions() {
        List<BuildBadgeAction> r = this.getActions(BuildBadgeAction.class);
        if (this.isKeepLog()) {
            r.add(new KeepLogBuildBadge());
        }
        return r;
    }

    @Exported
    public boolean isBuilding() {
        return this.state.compareTo(State.POST_PRODUCTION) < 0;
    }

    protected boolean isInProgress() {
        return this.state.equals((Object)State.BUILDING) || this.state.equals((Object)State.POST_PRODUCTION);
    }

    public boolean isLogUpdated() {
        return this.state.compareTo(State.COMPLETED) < 0;
    }

    @Exported
    @CheckForNull
    public Executor getExecutor() {
        return this instanceof Queue.Executable ? Executor.of((Queue.Executable)((Object)this)) : null;
    }

    @CheckForNull
    public Executor getOneOffExecutor() {
        for (Computer c : Jenkins.getInstance().getComputers()) {
            for (Executor executor : c.getOneOffExecutors()) {
                if (executor.getCurrentExecutable() != this) continue;
                return executor;
            }
        }
        return null;
    }

    @Nonnull
    public final Charset getCharset() {
        if (this.charset == null) {
            return Charset.defaultCharset();
        }
        return Charset.forName(this.charset);
    }

    @Nonnull
    public List<Cause> getCauses() {
        CauseAction a = this.getAction(CauseAction.class);
        if (a == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(a.getCauses());
    }

    @CheckForNull
    public <T extends Cause> T getCause(Class<T> type) {
        for (Cause c : this.getCauses()) {
            if (!type.isInstance(c)) continue;
            return (T)((Cause)type.cast(c));
        }
        return null;
    }

    @Exported
    public final boolean isKeepLog() {
        return this.getWhyKeepLog() != null;
    }

    @CheckForNull
    public String getWhyKeepLog() {
        if (this.keepLog) {
            return Messages.Run_MarkedExplicitly();
        }
        return null;
    }

    @Nonnull
    public JobT getParent() {
        return this.project;
    }

    @Exported
    @Nonnull
    public Calendar getTimestamp() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(this.timestamp);
        return c;
    }

    @Nonnull
    public final Date getTime() {
        return new Date(this.timestamp);
    }

    public final long getTimeInMillis() {
        return this.timestamp;
    }

    public final long getStartTimeInMillis() {
        if (this.startTime == 0L) {
            return this.timestamp;
        }
        return this.startTime;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getTruncatedDescription() {
        int maxDescrLength = 100;
        if (this.description == null || this.description.length() < 100) {
            return this.description;
        }
        String ending = "...";
        int sz = this.description.length();
        int maxTruncLength = 100 - "...".length();
        boolean inTag = false;
        int displayChars = 0;
        int lastTruncatablePoint = -1;
        for (int i = 0; i < sz; ++i) {
            char ch = this.description.charAt(i);
            if (ch == '<') {
                inTag = true;
            } else if (ch == '>') {
                inTag = false;
                if (displayChars <= maxTruncLength) {
                    lastTruncatablePoint = i + 1;
                }
            }
            if (inTag || ++displayChars > maxTruncLength || ch != ' ') continue;
            lastTruncatablePoint = i;
        }
        String truncDesc = this.description;
        if (lastTruncatablePoint == -1) {
            lastTruncatablePoint = maxTruncLength;
        }
        if (displayChars >= 100) {
            truncDesc = truncDesc.substring(0, lastTruncatablePoint) + "...";
        }
        return truncDesc;
    }

    @Nonnull
    public String getTimestampString() {
        long duration = new GregorianCalendar().getTimeInMillis() - this.timestamp;
        return Util.getPastTimeString(duration);
    }

    @Nonnull
    public String getTimestampString2() {
        return Util.XS_DATETIME_FORMATTER.format(new Date(this.timestamp));
    }

    @Nonnull
    public String getDurationString() {
        if (this.hasntStartedYet()) {
            return Messages.Run_NotStartedYet();
        }
        if (this.isBuilding()) {
            return Messages.Run_InProgressDuration(Util.getTimeSpanString(System.currentTimeMillis() - this.startTime));
        }
        return Util.getTimeSpanString(this.duration);
    }

    @Exported
    public long getDuration() {
        return this.duration;
    }

    @Nonnull
    public BallColor getIconColor() {
        if (!this.isBuilding()) {
            return this.getResult().color;
        }
        RunT pb = this.getPreviousBuild();
        BallColor baseColor = pb == null ? BallColor.NOTBUILT : ((Run)pb).getIconColor();
        return baseColor.anime();
    }

    public boolean hasntStartedYet() {
        return this.state == State.NOT_STARTED;
    }

    public String toString() {
        return ((AbstractItem)this.project).getFullName() + " #" + this.number;
    }

    @Exported
    public String getFullDisplayName() {
        return ((AbstractItem)this.project).getFullDisplayName() + ' ' + this.getDisplayName();
    }

    @Override
    @Exported
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : "#" + this.number;
    }

    public boolean hasCustomDisplayName() {
        return this.displayName != null;
    }

    public void setDisplayName(String value) throws IOException {
        this.checkPermission(UPDATE);
        this.displayName = value;
        this.save();
    }

    @Exported(visibility=2)
    public int getNumber() {
        return this.number;
    }

    @Nonnull
    protected BuildReference<RunT> createReference() {
        return new BuildReference<RunT>(this.getId(), this._this());
    }

    protected void dropLinks() {
        if (this.nextBuild != null) {
            ((Run)this.nextBuild).previousBuild = this.previousBuild;
        }
        if (this.previousBuild != null) {
            ((Run)this.previousBuild).nextBuild = this.nextBuild;
        }
    }

    @CheckForNull
    public RunT getPreviousBuild() {
        return this.previousBuild;
    }

    @CheckForNull
    public final RunT getPreviousCompletedBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && ((Run)r).isBuilding(); r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @CheckForNull
    public final RunT getPreviousBuildInProgress() {
        RunT answer;
        if (this.previousBuildInProgress == this) {
            return null;
        }
        ArrayList<RunT> fixUp = new ArrayList<RunT>();
        RunT r = this._this();
        while (true) {
            RunT n;
            if ((n = ((Run)r).previousBuildInProgress) == null) {
                n = ((Run)r).getPreviousBuild();
                fixUp.add(r);
            }
            if (r == n || n == null) {
                answer = null;
                break;
            }
            if (((Run)n).isBuilding()) {
                answer = n;
                break;
            }
            fixUp.add(r);
            r = n;
        }
        for (Run<JobT, RunT> f : fixUp) {
            f.previousBuildInProgress = answer == null ? f : answer;
        }
        return answer;
    }

    @CheckForNull
    public RunT getPreviousBuiltBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && (((Run)r).getResult() == null || ((Run)r).getResult() == Result.NOT_BUILT); r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @CheckForNull
    public RunT getPreviousNotFailedBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && ((Run)r).getResult() == Result.FAILURE; r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @CheckForNull
    public RunT getPreviousFailedBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && ((Run)r).getResult() != Result.FAILURE; r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @CheckForNull
    public RunT getPreviousSuccessfulBuild() {
        RunT r;
        for (r = this.getPreviousBuild(); r != null && ((Run)r).getResult() != Result.SUCCESS; r = ((Run)r).getPreviousBuild()) {
        }
        return r;
    }

    @Nonnull
    public List<RunT> getPreviousBuildsOverThreshold(int numberOfBuilds, @Nonnull Result threshold) {
        ArrayList<RunT> builds = new ArrayList<RunT>(numberOfBuilds);
        for (RunT r = this.getPreviousBuild(); r != null && builds.size() < numberOfBuilds; r = ((Run)r).getPreviousBuild()) {
            if (((Run)r).isBuilding() || ((Run)r).getResult() == null || !((Run)r).getResult().isBetterOrEqualTo(threshold)) continue;
            builds.add(r);
        }
        return builds;
    }

    @CheckForNull
    public RunT getNextBuild() {
        return this.nextBuild;
    }

    @Nonnull
    public String getUrl() {
        String seed;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && (seed = Functions.getNearestAncestorUrl(req, this)) != null) {
            return seed.substring(req.getContextPath().length() + 1) + '/';
        }
        return ((AbstractItem)this.project).getUrl() + this.getNumber() + '/';
    }

    @Exported(visibility=2, name="url")
    @Deprecated
    @Nonnull
    public final String getAbsoluteUrl() {
        return ((AbstractItem)this.project).getAbsoluteUrl() + this.getNumber() + '/';
    }

    @Override
    @Nonnull
    public final String getSearchUrl() {
        return this.getNumber() + "/";
    }

    @Exported
    @Nonnull
    public String getId() {
        return this.id != null ? this.id : Integer.toString(this.number);
    }

    @Override
    @CheckForNull
    public Descriptor getDescriptorByName(String className) {
        return Jenkins.getInstance().getDescriptorByName(className);
    }

    @Override
    @Nonnull
    public File getRootDir() {
        return new File(((Job)this.project).getBuildDir(), Integer.toString(this.number));
    }

    @Nonnull
    public final ArtifactManager getArtifactManager() {
        return this.artifactManager != null ? this.artifactManager : new StandardArtifactManager(this);
    }

    @Nonnull
    public final synchronized ArtifactManager pickArtifactManager() throws IOException {
        if (this.artifactManager != null) {
            return this.artifactManager;
        }
        for (ArtifactManagerFactory f : ArtifactManagerConfiguration.get().getArtifactManagerFactories()) {
            ArtifactManager mgr = f.managerFor(this);
            if (mgr == null) continue;
            this.artifactManager = mgr;
            this.save();
            return mgr;
        }
        return new StandardArtifactManager(this);
    }

    @Deprecated
    public File getArtifactsDir() {
        return new File(this.getRootDir(), "archive");
    }

    @Exported
    @Nonnull
    public List<Artifact> getArtifacts() {
        return this.getArtifactsUpTo(Integer.MAX_VALUE);
    }

    @Nonnull
    public List<Artifact> getArtifactsUpTo(int artifactsNumber) {
        ArtifactList r = new ArtifactList();
        try {
            this.addArtifacts(this.getArtifactManager().root(), "", "", r, null, artifactsNumber);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        r.computeDisplayName();
        return r;
    }

    public boolean getHasArtifacts() {
        return !this.getArtifactsUpTo(1).isEmpty();
    }

    private int addArtifacts(@Nonnull VirtualFile dir, @Nonnull String path, @Nonnull String pathHref, @Nonnull ArtifactList r, @Nonnull Artifact parent, int upTo) throws IOException {
        Object[] kids = dir.list();
        Arrays.sort(kids);
        int n = 0;
        for (Object sub : kids) {
            Artifact a;
            boolean collapsed;
            String child = ((VirtualFile)sub).getName();
            String childPath = path + child;
            String childHref = pathHref + Util.rawEncode(child);
            String length = ((VirtualFile)sub).isFile() ? String.valueOf(((VirtualFile)sub).length()) : "";
            boolean bl = collapsed = kids.length == 1 && parent != null;
            if (collapsed) {
                a = new Artifact(parent.getFileName() + '/' + child, childPath, ((VirtualFile)sub).isDirectory() ? null : childHref, length, parent.getTreeNodeId());
                r.tree.put(a, r.tree.remove(parent));
            } else {
                a = new Artifact(child, childPath, ((VirtualFile)sub).isDirectory() ? null : childHref, length, "n" + ++r.idSeq);
                r.tree.put(a, parent != null ? parent.getTreeNodeId() : null);
            }
            if (((VirtualFile)sub).isDirectory()) {
                if ((n += this.addArtifacts((VirtualFile)sub, childPath + '/', childHref + '/', r, a, upTo - n)) < upTo) continue;
                break;
            }
            r.add(collapsed ? new Artifact(child, a.relativePath, a.href, length, a.treeNodeId) : a);
            if (++n >= upTo) break;
        }
        return n;
    }

    @Nonnull
    public File getLogFile() {
        File rawF = new File(this.getRootDir(), "log");
        if (rawF.isFile()) {
            return rawF;
        }
        File gzF = new File(this.getRootDir(), "log.gz");
        if (gzF.isFile()) {
            return gzF;
        }
        return rawF;
    }

    @Nonnull
    public InputStream getLogInputStream() throws IOException {
        File logFile = this.getLogFile();
        if (logFile.exists()) {
            FileInputStream fis = new FileInputStream(logFile);
            if (logFile.getName().endsWith(".gz")) {
                return new GZIPInputStream((InputStream)fis);
            }
            return fis;
        }
        String message = "No such file: " + logFile;
        return new ByteArrayInputStream(this.charset != null ? message.getBytes(this.charset) : message.getBytes());
    }

    @Nonnull
    public Reader getLogReader() throws IOException {
        if (this.charset == null) {
            return new InputStreamReader(this.getLogInputStream());
        }
        return new InputStreamReader(this.getLogInputStream(), this.charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLogTo(long offset, @Nonnull XMLOutput out) throws IOException {
        try {
            this.getLogText().writeHtmlTo(offset, out.asWriter());
        }
        catch (IOException e) {
            InputStream input = this.getLogInputStream();
            try {
                IOUtils.copy((InputStream)input, (Writer)out.asWriter());
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }

    public void writeWholeLogTo(@Nonnull OutputStream out) throws IOException, InterruptedException {
        long pos = 0L;
        AnnotatedLargeText logText = this.getLogText();
        pos = logText.writeLogTo(pos, out);
        while (!logText.isComplete()) {
            Thread.sleep(1000L);
            logText = this.getLogText();
            pos = logText.writeLogTo(pos, out);
        }
    }

    @Nonnull
    public AnnotatedLargeText getLogText() {
        return new AnnotatedLargeText<Run>(this.getLogFile(), this.getCharset(), !this.isLogUpdated(), this);
    }

    @Override
    @Nonnull
    protected SearchIndexBuilder makeSearchIndex() {
        SearchIndexBuilder builder = super.makeSearchIndex().add("console").add("changes");
        for (Action action : this.getAllActions()) {
            if (action.getIconFileName() == null) continue;
            builder.add(action.getUrlName());
        }
        return builder;
    }

    @Nonnull
    public Api getApi() {
        return new Api(this);
    }

    @Override
    public void checkPermission(@Nonnull Permission p) {
        this.getACL().checkPermission(p);
    }

    @Override
    public boolean hasPermission(@Nonnull Permission p) {
        return this.getACL().hasPermission(p);
    }

    @Override
    public ACL getACL() {
        return ((Job)this.getParent()).getACL();
    }

    public synchronized void deleteArtifacts() throws IOException {
        try {
            this.getArtifactManager().delete();
        }
        catch (InterruptedException x) {
            throw new IOException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        File rootDir = this.getRootDir();
        if (!rootDir.isDirectory()) {
            throw new IOException(this + ": " + rootDir + " looks to have already been deleted; siblings: " + Arrays.toString(((Job)this.project).getBuildDir().list()));
        }
        RunListener.fireDeleted(this);
        Run run = this;
        synchronized (run) {
            File tmp = new File(rootDir.getParentFile(), '.' + rootDir.getName());
            if (tmp.exists()) {
                Util.deleteRecursive(tmp);
            }
            boolean renamingSucceeded = rootDir.renameTo(tmp);
            Util.deleteRecursive(tmp);
            if (tmp.exists()) {
                tmp.deleteOnExit();
            }
            if (!renamingSucceeded) {
                throw new IOException(rootDir + " is in use");
            }
            LOGGER.log(Level.FINE, "{0}: {1} successfully deleted", new Object[]{this, rootDir});
            this.removeRunFromParent();
        }
    }

    private void removeRunFromParent() {
        ((Job)this.getParent()).removeRun((Run)this);
    }

    static void reportCheckpoint(@Nonnull CheckPoint id) {
        RunExecution exec = RunnerStack.INSTANCE.peek();
        if (exec == null) {
            return;
        }
        exec.checkpoints.report(id);
    }

    static void waitForCheckpoint(@Nonnull CheckPoint id, @CheckForNull BuildListener listener, @CheckForNull String waiter) throws InterruptedException {
        while (true) {
            RunExecution exec;
            if ((exec = RunnerStack.INSTANCE.peek()) == null) {
                return;
            }
            Object b = ((Run)exec.getBuild()).getPreviousBuildInProgress();
            if (b == null) {
                return;
            }
            RunExecution runner = ((Run)b).runner;
            if (runner == null) {
                Thread.sleep(0L);
                continue;
            }
            if (runner.checkpoints.waitForCheckPoint(id, listener, waiter)) break;
        }
    }

    @Deprecated
    protected final void run(@Nonnull Runner job) {
        this.execute(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute(@Nonnull RunExecution job) {
        if (this.result != null) {
            return;
        }
        StreamTaskListener listener = null;
        this.runner = job;
        this.onStartBuilding();
        try {
            long start = System.currentTimeMillis();
            try {
                try {
                    Computer computer = Computer.currentComputer();
                    Charset charset = null;
                    if (computer != null) {
                        charset = computer.getDefaultCharset();
                        this.charset = charset.name();
                    }
                    listener = this.createBuildListener(job, (StreamBuildListener)listener, charset);
                    ((StreamBuildListener)listener).started(this.getCauses());
                    Authentication auth = Jenkins.getAuthentication();
                    if (!auth.equals(ACL.SYSTEM)) {
                        String name = auth.getName();
                        if (!auth.equals(Jenkins.ANONYMOUS)) {
                            name = ModelHyperlinkNote.encodeTo(User.get(name));
                        }
                        listener.getLogger().println(Messages.Run_running_as_(name));
                    }
                    RunListener.fireStarted(this, listener);
                    this.updateSymlinks(listener);
                    this.setResult(job.run((BuildListener)((Object)listener)));
                    LOGGER.log(Level.INFO, "{0} main build action completed: {1}", new Object[]{this, this.result});
                    CheckPoint.MAIN_COMPLETED.report();
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (AbortException e) {
                    this.result = Result.FAILURE;
                    listener.error(e.getMessage());
                    LOGGER.log(Level.FINE, "Build " + this + " aborted", e);
                }
                catch (RunnerAbortedException e) {
                    this.result = Result.FAILURE;
                    LOGGER.log(Level.FINE, "Build " + this + " aborted", e);
                }
                catch (InterruptedException e) {
                    this.result = Executor.currentExecutor().abortResult();
                    listener.getLogger().println(Messages.Run_BuildAborted());
                    Executor.currentExecutor().recordCauseOfInterruption(this, listener);
                    LOGGER.log(Level.INFO, this + " aborted", e);
                }
                catch (Throwable e) {
                    this.handleFatalBuildProblem((BuildListener)((Object)listener), e);
                    this.result = Result.FAILURE;
                }
                job.post((BuildListener)((Object)listener));
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable e) {
                this.handleFatalBuildProblem((BuildListener)((Object)listener), e);
                this.result = Result.FAILURE;
            }
            finally {
                long end = System.currentTimeMillis();
                this.duration = Math.max(end - start, 0L);
                LOGGER.log(Level.FINER, "moving into POST_PRODUCTION on {0}", this);
                this.state = State.POST_PRODUCTION;
                if (listener != null) {
                    RunListener.fireCompleted(this, listener);
                    try {
                        job.cleanUp((BuildListener)((Object)listener));
                    }
                    catch (Exception e) {
                        this.handleFatalBuildProblem((BuildListener)((Object)listener), e);
                    }
                    ((StreamBuildListener)listener).finished(this.result);
                    listener.closeQuietly();
                }
                try {
                    this.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to save build record", e);
                }
            }
            try {
                ((Job)this.getParent()).logRotate();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to rotate log", e);
            }
        }
        finally {
            this.onEndBuilding();
        }
    }

    private StreamBuildListener createBuildListener(@Nonnull RunExecution job, StreamBuildListener listener, Charset charset) throws IOException, InterruptedException {
        OutputStream logger = new FileOutputStream(this.getLogFile(), true);
        Object build = job.getBuild();
        for (ConsoleLogFilter filter : ConsoleLogFilter.all()) {
            logger = filter.decorateLogger((Run)build, logger);
        }
        if (this.project instanceof BuildableItemWithBuildWrappers && build instanceof AbstractBuild) {
            BuildableItemWithBuildWrappers biwbw = (BuildableItemWithBuildWrappers)this.project;
            for (BuildWrapper bw : biwbw.getBuildWrappersList()) {
                logger = bw.decorateLogger((AbstractBuild)build, logger);
            }
        }
        listener = new StreamBuildListener(logger, charset);
        return listener;
    }

    public final void updateSymlinks(@Nonnull TaskListener listener) throws InterruptedException {
        this.createSymlink(listener, "lastSuccessful", PermalinkProjectAction.Permalink.LAST_SUCCESSFUL_BUILD);
        this.createSymlink(listener, "lastStable", PermalinkProjectAction.Permalink.LAST_STABLE_BUILD);
    }

    private void createSymlink(@Nonnull TaskListener listener, @Nonnull String name, @Nonnull PermalinkProjectAction.Permalink target) throws InterruptedException {
        File rootDir;
        File buildDir = ((Job)this.getParent()).getBuildDir();
        String targetDir = buildDir.equals(new File(rootDir = ((AbstractItem)this.getParent()).getRootDir(), "builds")) ? "builds" + File.separator + target.getId() : buildDir + File.separator + target.getId();
        Util.createSymlink(rootDir, targetDir, name, listener);
    }

    private void handleFatalBuildProblem(@Nonnull BuildListener listener, @Nonnull Throwable e) {
        if (listener != null) {
            LOGGER.log(Level.FINE, this.getDisplayName() + " failed to build", e);
            if (e instanceof IOException) {
                Util.displayIOException((IOException)e, listener);
            }
            e.printStackTrace(listener.fatalError(e.getMessage()));
        } else {
            LOGGER.log(Level.SEVERE, this.getDisplayName() + " failed to build and we don't even have a listener", e);
        }
    }

    protected void onStartBuilding() {
        LOGGER.log(Level.FINER, "moving to BUILDING on {0}", this);
        this.state = State.BUILDING;
        this.startTime = System.currentTimeMillis();
        if (this.runner != null) {
            RunnerStack.INSTANCE.push(this.runner);
        }
        RunListener.fireInitialize(this);
    }

    protected void onEndBuilding() {
        this.state = State.COMPLETED;
        LOGGER.log(Level.FINER, "moving to COMPLETED on {0}", this);
        if (this.runner != null) {
            ((RunExecution.CheckpointSet)this.runner.checkpoints).allDone();
            this.runner = null;
            RunnerStack.INSTANCE.pop();
        }
        if (this.result == null) {
            this.result = Result.FAILURE;
            LOGGER.log(Level.WARNING, "{0}: No build result is set, so marking as failure. This should not happen.", this);
        }
        RunListener.fireFinalized(this);
    }

    @Override
    public synchronized void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        this.getDataFile().write(this);
        SaveableListener.fireOnChange(this, this.getDataFile());
    }

    @Nonnull
    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getRootDir(), "build.xml"));
    }

    @Deprecated
    @Nonnull
    public String getLog() throws IOException {
        return Util.loadFile(this.getLogFile(), this.getCharset());
    }

    @Nonnull
    public List<String> getLog(int maxLines) throws IOException {
        int lineCount = 0;
        LinkedList<String> logLines = new LinkedList<String>();
        if (maxLines == 0) {
            return logLines;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getLogFile()), this.getCharset()));){
            String line = reader.readLine();
            while (line != null) {
                logLines.add(line);
                if (++lineCount > maxLines) {
                    logLines.remove(0);
                }
                line = reader.readLine();
            }
        }
        if (lineCount > maxLines) {
            logLines.set(0, "[...truncated " + (lineCount - (maxLines - 1)) + " lines...]");
        }
        return ConsoleNote.removeNotes(logLines);
    }

    public void doBuildStatus(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/48x48/" + this.getBuildStatusUrl());
    }

    @Nonnull
    public String getBuildStatusUrl() {
        return this.getIconColor().getImage();
    }

    public String getBuildStatusIconClassName() {
        return this.getIconColor().getIconClassName();
    }

    @Nonnull
    public Summary getBuildStatusSummary() {
        if (this.isBuilding()) {
            return new Summary(false, Messages.Run_Summary_Unknown());
        }
        ResultTrend trend = ResultTrend.getResultTrend(this);
        for (StatusSummarizer summarizer : ExtensionList.lookup(StatusSummarizer.class)) {
            Summary summary = summarizer.summarize(this, trend);
            if (summary == null) continue;
            return summary;
        }
        switch (trend) {
            case ABORTED: {
                return new Summary(false, Messages.Run_Summary_Aborted());
            }
            case NOT_BUILT: {
                return new Summary(false, Messages.Run_Summary_NotBuilt());
            }
            case FAILURE: {
                return new Summary(true, Messages.Run_Summary_BrokenSinceThisBuild());
            }
            case STILL_FAILING: {
                RunT since = this.getPreviousNotFailedBuild();
                if (since == null) {
                    return new Summary(false, Messages.Run_Summary_BrokenForALongTime());
                }
                RunT failedBuild = ((Run)since).getNextBuild();
                return new Summary(false, Messages.Run_Summary_BrokenSince(((Run)failedBuild).getDisplayName()));
            }
            case NOW_UNSTABLE: 
            case STILL_UNSTABLE: {
                return new Summary(false, Messages.Run_Summary_Unstable());
            }
            case UNSTABLE: {
                return new Summary(true, Messages.Run_Summary_Unstable());
            }
            case SUCCESS: {
                return new Summary(false, Messages.Run_Summary_Stable());
            }
            case FIXED: {
                return new Summary(false, Messages.Run_Summary_BackToNormal());
            }
        }
        return new Summary(false, Messages.Run_Summary_Unknown());
    }

    @Nonnull
    public DirectoryBrowserSupport doArtifact() {
        if (Functions.isArtifactsPermissionEnabled()) {
            this.checkPermission(ARTIFACTS);
        }
        return new DirectoryBrowserSupport((ModelObject)this, this.getArtifactManager().root(), Messages.Run_ArtifactsBrowserTitle(((AbstractItem)this.project).getDisplayName(), this.getDisplayName()), "package.png", true);
    }

    public void doBuildNumber(StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain");
        rsp.setCharacterEncoding("US-ASCII");
        rsp.setStatus(200);
        rsp.getWriter().print(this.number);
    }

    public void doBuildTimestamp(StaplerRequest req, StaplerResponse rsp, @QueryParameter String format) throws IOException {
        rsp.setContentType("text/plain");
        rsp.setCharacterEncoding("US-ASCII");
        rsp.setStatus(200);
        DateFormat df = format == null ? DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH) : new SimpleDateFormat(format, req.getLocale());
        rsp.getWriter().print(df.format(this.getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConsoleText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain;charset=UTF-8");
        PlainTextConsoleOutputStream out = new PlainTextConsoleOutputStream(rsp.getCompressedOutputStream((HttpServletRequest)req));
        InputStream input = this.getLogInputStream();
        try {
            IOUtils.copy((InputStream)input, (OutputStream)out);
            out.flush();
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Deprecated
    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.getLogText().doProgressText(req, rsp);
    }

    public boolean canToggleLogKeep() {
        return this.keepLog || !this.isKeepLog();
    }

    public void doToggleLogKeep(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.keepLog(!this.keepLog);
        rsp.forwardToPreviousPage(req);
    }

    @CLIMethod(name="keep-build")
    public final void keepLog() throws IOException {
        this.keepLog(true);
    }

    public void keepLog(boolean newValue) throws IOException {
        this.checkPermission(newValue ? UPDATE : DELETE);
        this.keepLog = newValue;
        this.save();
    }

    @RequirePOST
    public void doDoDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(DELETE);
        String why = this.getWhyKeepLog();
        if (why != null) {
            this.sendError(Messages.Run_UnableToDelete(this.getFullDisplayName(), why), req, rsp);
            return;
        }
        try {
            this.delete();
        }
        catch (IOException ex) {
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            req.setAttribute("stackTraces", (Object)writer);
            req.getView((Object)this, "delete-retry.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        rsp.sendRedirect2(req.getContextPath() + '/' + ((AbstractItem)this.getParent()).getUrl());
    }

    public void setDescription(String description) throws IOException {
        this.checkPermission(UPDATE);
        this.description = description;
        this.save();
    }

    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.setDescription(req.getParameter("description"));
        rsp.sendRedirect(".");
    }

    @Deprecated
    public Map<String, String> getEnvVars() {
        LOGGER.log(Level.WARNING, "deprecated call to Run.getEnvVars\n\tat {0}", new Throwable().getStackTrace()[1]);
        try {
            return this.getEnvironment(new LogTaskListener(LOGGER, Level.INFO));
        }
        catch (IOException e) {
            return new EnvVars();
        }
        catch (InterruptedException e) {
            return new EnvVars();
        }
    }

    @Deprecated
    public EnvVars getEnvironment() throws IOException, InterruptedException {
        LOGGER.log(Level.WARNING, "deprecated call to Run.getEnvironment\n\tat {0}", new Throwable().getStackTrace()[1]);
        return this.getEnvironment(new LogTaskListener(LOGGER, Level.INFO));
    }

    @Nonnull
    public EnvVars getEnvironment(@Nonnull TaskListener listener) throws IOException, InterruptedException {
        Computer c = Computer.currentComputer();
        Node n = c == null ? null : c.getNode();
        EnvVars env = ((Job)this.getParent()).getEnvironment(n, listener);
        env.putAll(this.getCharacteristicEnvVars());
        for (EnvironmentContributor ec : EnvironmentContributor.all().reverseView()) {
            ec.buildEnvironmentFor(this, env, listener);
        }
        return env;
    }

    @Nonnull
    public final EnvVars getCharacteristicEnvVars() {
        EnvVars env = ((Job)this.getParent()).getCharacteristicEnvVars();
        env.put("BUILD_NUMBER", String.valueOf(this.number));
        env.put("BUILD_ID", this.getId());
        env.put("BUILD_TAG", "jenkins-" + ((AbstractItem)this.getParent()).getFullName().replace('/', '-') + "-" + this.number);
        return env;
    }

    @Nonnull
    public String getExternalizableId() {
        return ((AbstractItem)this.project).getFullName() + "#" + this.getNumber();
    }

    @CheckForNull
    public static Run<?, ?> fromExternalizableId(String id) throws IllegalArgumentException {
        int number;
        int hash = id.lastIndexOf(35);
        if (hash <= 0) {
            throw new IllegalArgumentException("Invalid id");
        }
        String jobName = id.substring(0, hash);
        try {
            number = Integer.parseInt(id.substring(hash + 1));
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(x);
        }
        Jenkins j = Jenkins.getInstance();
        Job job = j.getItemByFullName(jobName, Job.class);
        if (job == null) {
            return null;
        }
        return job.getBuildByNumber(number);
    }

    @Exported
    public long getEstimatedDuration() {
        return ((Job)this.project).getEstimatedDuration();
    }

    @RequirePOST
    @Nonnull
    public HttpResponse doConfigSubmit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(UPDATE);
        try (BulkChange bc = new BulkChange(this);){
            JSONObject json = req.getSubmittedForm();
            this.submit(json);
            bc.commit();
        }
        return FormApply.success(".");
    }

    protected void submit(JSONObject json) throws IOException {
        this.setDisplayName(Util.fixEmptyAndTrim(json.getString("displayName")));
        this.setDescription(json.getString("description"));
    }

    @Override
    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        Object returnedResult = super.getDynamic(token, req, rsp);
        if (returnedResult == null) {
            for (Action action : this.getTransientActions()) {
                String urlName = action.getUrlName();
                if (urlName == null || !urlName.equals(token)) continue;
                return action;
            }
            returnedResult = new RedirectUp();
        }
        return returnedResult;
    }

    static {
        XSTREAM.alias("build", FreeStyleBuild.class);
        XSTREAM.registerConverter(Result.conv);
        LOGGER = Logger.getLogger(Run.class.getName());
        ORDER_BY_DATE = new Comparator<Run>(){

            @Override
            public int compare(@Nonnull Run lhs, @Nonnull Run rhs) {
                long rt;
                long lt = lhs.getTimeInMillis();
                if (lt > (rt = rhs.getTimeInMillis())) {
                    return -1;
                }
                if (lt < rt) {
                    return 1;
                }
                return 0;
            }
        };
        FEED_ADAPTER = new DefaultFeedAdapter();
        FEED_ADAPTER_LATEST = new DefaultFeedAdapter(){

            @Override
            public String getEntryID(Run e) {
                return "tag:hudson.dev.java.net,2008:" + ((AbstractItem)e.getParent()).getAbsoluteUrl();
            }
        };
        PERMISSIONS = new PermissionGroup(Run.class, Messages._Run_Permissions_Title());
        DELETE = new Permission(PERMISSIONS, "Delete", Messages._Run_DeletePermission_Description(), Permission.DELETE, PermissionScope.RUN);
        UPDATE = new Permission(PERMISSIONS, "Update", Messages._Run_UpdatePermission_Description(), Permission.UPDATE, PermissionScope.RUN);
        ARTIFACTS = new Permission(PERMISSIONS, "Artifacts", Messages._Run_ArtifactsPermission_Description(), null, Functions.isArtifactsPermissionEnabled(), new PermissionScope[]{PermissionScope.RUN});
    }

    public static class RedirectUp {
        public void doDynamic(StaplerResponse rsp) throws IOException {
            rsp.setStatus(404);
            rsp.setContentType("text/html;charset=UTF-8");
            PrintWriter out = rsp.getWriter();
            out.println("<html><head><meta http-equiv='refresh' content='1;url=..'/><script>window.location.replace('..');</script></head><body style='background-color:white; color:white;'>Not found</body></html>");
            out.flush();
        }
    }

    private static class DefaultFeedAdapter
    implements FeedAdapter<Run> {
        private DefaultFeedAdapter() {
        }

        @Override
        public String getEntryTitle(Run entry) {
            return entry + " (" + entry.getBuildStatusSummary().message + ")";
        }

        @Override
        public String getEntryUrl(Run entry) {
            return entry.getUrl();
        }

        @Override
        public String getEntryID(Run entry) {
            return "tag:hudson.dev.java.net," + entry.getTimestamp().get(1) + ":" + ((AbstractItem)entry.getParent()).getFullName() + ':' + entry.getId();
        }

        @Override
        public String getEntryDescription(Run entry) {
            return entry.getDescription();
        }

        @Override
        public Calendar getEntryTimestamp(Run entry) {
            return entry.getTimestamp();
        }

        @Override
        public String getEntryAuthor(Run entry) {
            return JenkinsLocationConfiguration.get().getAdminAddress();
        }
    }

    public final class KeepLogBuildBadge
    implements BuildBadgeAction {
        @Override
        @CheckForNull
        public String getIconFileName() {
            return null;
        }

        @Override
        @CheckForNull
        public String getDisplayName() {
            return null;
        }

        @Override
        @CheckForNull
        public String getUrlName() {
            return null;
        }

        @CheckForNull
        public String getWhyKeepLog() {
            return Run.this.getWhyKeepLog();
        }
    }

    public static abstract class StatusSummarizer
    implements ExtensionPoint {
        @CheckForNull
        public abstract Summary summarize(@Nonnull Run<?, ?> var1, @Nonnull ResultTrend var2);
    }

    public static class Summary {
        public boolean isWorse;
        public String message;

        public Summary(boolean worse, String message) {
            this.isWorse = worse;
            this.message = message;
        }
    }

    public static final class RunnerAbortedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public abstract class RunExecution {
        private final hudson.model.Run$RunExecution.CheckpointSet checkpoints = new CheckpointSet();
        private final Map<Object, Object> attributes = new HashMap<Object, Object>();

        @Nonnull
        public abstract Result run(@Nonnull BuildListener var1) throws Exception, RunnerAbortedException;

        public abstract void post(@Nonnull BuildListener var1) throws Exception;

        public abstract void cleanUp(@Nonnull BuildListener var1) throws Exception;

        @Nonnull
        public RunT getBuild() {
            return Run.this._this();
        }

        @Nonnull
        public JobT getProject() {
            return ((Run)Run.this._this()).getParent();
        }

        @Nonnull
        public Map<Object, Object> getAttributes() {
            return this.attributes;
        }

        private final class CheckpointSet {
            private final Set<CheckPoint> checkpoints = new HashSet<CheckPoint>();
            private boolean allDone;

            private CheckpointSet() {
            }

            protected synchronized void report(@Nonnull CheckPoint identifier) {
                this.checkpoints.add(identifier);
                this.notifyAll();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected synchronized boolean waitForCheckPoint(@Nonnull CheckPoint identifier, @CheckForNull BuildListener listener, @CheckForNull String waiter) throws InterruptedException {
                Thread t = Thread.currentThread();
                String oldName = t.getName();
                t.setName(oldName + " : waiting for " + identifier + " on " + Run.this.getFullDisplayName() + " from " + waiter);
                try {
                    boolean first = true;
                    while (!this.allDone && !this.checkpoints.contains(identifier)) {
                        if (first && listener != null && waiter != null) {
                            listener.getLogger().println(Messages.Run__is_waiting_for_a_checkpoint_on_(waiter, Run.this.getFullDisplayName()));
                        }
                        this.wait();
                        first = false;
                    }
                    boolean bl = this.checkpoints.contains(identifier);
                    return bl;
                }
                finally {
                    t.setName(oldName);
                }
            }

            private synchronized void allDone() {
                this.allDone = true;
                this.notifyAll();
            }
        }
    }

    @Deprecated
    protected abstract class Runner
    extends RunExecution {
        protected Runner() {
        }
    }

    @ExportedBean
    public class Artifact {
        @Exported(visibility=3)
        public final String relativePath;
        String displayPath;
        private String name;
        private String href;
        private String treeNodeId;
        private String length;

        Artifact(String name, String relativePath, String href, String len, String treeNodeId) {
            this.name = name;
            this.relativePath = relativePath;
            this.href = href;
            this.treeNodeId = treeNodeId;
            this.length = len;
        }

        @Deprecated
        @Nonnull
        public File getFile() {
            return new File(Run.this.getArtifactsDir(), this.relativePath);
        }

        @Exported(visibility=3)
        public String getFileName() {
            return this.name;
        }

        @Exported(visibility=3)
        public String getDisplayPath() {
            return this.displayPath;
        }

        public String getHref() {
            return this.href;
        }

        public String getLength() {
            return this.length;
        }

        public long getFileSize() {
            return Long.decode(this.length);
        }

        public String getTreeNodeId() {
            return this.treeNodeId;
        }

        public String toString() {
            return this.relativePath;
        }
    }

    public final class ArtifactList
    extends ArrayList<Artifact> {
        private static final long serialVersionUID = 1L;
        private LinkedHashMap<Artifact, String> tree = new LinkedHashMap();
        private int idSeq = 0;

        public Map<Artifact, String> getTree() {
            return this.tree;
        }

        public void computeDisplayName() {
            boolean collision;
            if (this.size() > LIST_CUTOFF) {
                return;
            }
            int maxDepth = 0;
            int[] len = new int[this.size()];
            String[][] tokens = new String[this.size()][];
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = ((Artifact)this.get((int)i)).relativePath.split("[\\\\/]+");
                maxDepth = Math.max(maxDepth, tokens[i].length);
                len[i] = 1;
            }
            int depth = 0;
            do {
                collision = false;
                HashMap<String, Integer> names = new HashMap<String, Integer>();
                for (int i = 0; i < tokens.length; ++i) {
                    String[] token = tokens[i];
                    String displayName = this.combineLast(token, len[i]);
                    Integer j = names.put(displayName, i);
                    if (j == null) continue;
                    collision = true;
                    if (j >= 0) {
                        int n = j;
                        len[n] = len[n] + 1;
                    }
                    int n = i;
                    len[n] = len[n] + 1;
                    names.put(displayName, -1);
                }
            } while (collision && depth++ < maxDepth);
            for (int i = 0; i < tokens.length; ++i) {
                ((Artifact)this.get((int)i)).displayPath = this.combineLast(tokens[i], len[i]);
            }
        }

        private String combineLast(String[] token, int n) {
            StringBuilder buf = new StringBuilder();
            for (int i = Math.max(0, token.length - n); i < token.length; ++i) {
                if (buf.length() > 0) {
                    buf.append('/');
                }
                buf.append(token[i]);
            }
            return buf.toString();
        }
    }

    private static enum State {
        NOT_STARTED,
        BUILDING,
        POST_PRODUCTION,
        COMPLETED;

    }
}

