/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.cli.CLICommand;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.util.DescriptorList;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=3)
public abstract class ParameterDefinition
implements Describable<ParameterDefinition>,
ExtensionPoint,
Serializable {
    private final String name;
    private final String description;
    @Deprecated
    public static final DescriptorList<ParameterDefinition> LIST = new DescriptorList<ParameterDefinition>(ParameterDefinition.class);
    private static final Logger LOGGER = Logger.getLogger(ParameterDefinition.class.getName());

    public ParameterDefinition(String name) {
        this(name, null);
    }

    public ParameterDefinition(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        return this;
    }

    @Exported
    public String getType() {
        return this.getClass().getSimpleName();
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    public String getFormattedDescription() {
        try {
            return Jenkins.getInstance().getMarkupFormatter().translate(this.description);
        }
        catch (IOException e) {
            LOGGER.warning("failed to translate description using configured markup formatter");
            return "";
        }
    }

    public ParameterDescriptor getDescriptor() {
        return (ParameterDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    @CheckForNull
    public abstract ParameterValue createValue(StaplerRequest var1, JSONObject var2);

    @CheckForNull
    public abstract ParameterValue createValue(StaplerRequest var1);

    @CheckForNull
    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        throw new AbortException("CLI parameter submission is not supported for the " + this.getClass() + " type. Please file a bug report for this");
    }

    @CheckForNull
    @Exported
    public ParameterValue getDefaultParameterValue() {
        return null;
    }

    public static DescriptorExtensionList<ParameterDefinition, ParameterDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(ParameterDefinition.class);
    }

    public static abstract class ParameterDescriptor
    extends Descriptor<ParameterDefinition> {
        protected ParameterDescriptor(Class<? extends ParameterDefinition> klazz) {
            super(klazz);
        }

        protected ParameterDescriptor() {
        }

        public String getValuePage() {
            return this.getViewPage(this.clazz, "index.jelly");
        }

        @Override
        public String getDisplayName() {
            return "Parameter";
        }
    }
}

