/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.FilePath;
import hudson.Util;
import hudson.model.ModelObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.SystemProperties;
import jenkins.util.VirtualFile;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class DirectoryBrowserSupport
implements HttpResponse {
    public final ModelObject owner;
    public final String title;
    private final VirtualFile base;
    private final String icon;
    private final boolean serveDirIndex;
    private String indexFileName = "index.html";
    private static final Logger LOGGER = Logger.getLogger(DirectoryBrowserSupport.class.getName());
    @Restricted(value={NoExternalUse.class})
    public static final String DEFAULT_CSP_VALUE = "sandbox; default-src 'none'; img-src 'self'; style-src 'self';";

    @Deprecated
    public DirectoryBrowserSupport(ModelObject owner, String title) {
        this(owner, (VirtualFile)null, title, null, false);
    }

    public DirectoryBrowserSupport(ModelObject owner, FilePath base, String title, String icon, boolean serveDirIndex) {
        this(owner, base.toVirtualFile(), title, icon, serveDirIndex);
    }

    public DirectoryBrowserSupport(ModelObject owner, VirtualFile base, String title, String icon, boolean serveDirIndex) {
        this.owner = owner;
        this.base = base;
        this.title = title;
        this.icon = icon;
        this.serveDirIndex = serveDirIndex;
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        try {
            this.serveFile(req, rsp, this.base, this.icon, this.serveDirIndex);
        }
        catch (InterruptedException e) {
            throw new IOException("interrupted", e);
        }
    }

    public void setIndexFileName(String fileName) {
        this.indexFileName = fileName;
    }

    @Deprecated
    public void serveFile(StaplerRequest req, StaplerResponse rsp, FilePath root, String icon, boolean serveDirIndex) throws IOException, ServletException, InterruptedException {
        this.serveFile(req, rsp, root.toVirtualFile(), icon, serveDirIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(StaplerRequest req, StaplerResponse rsp, VirtualFile root, String icon, boolean serveDirIndex) throws IOException, ServletException, InterruptedException {
        String pattern = req.getParameter("pattern");
        if (pattern == null) {
            pattern = req.getParameter("path");
        }
        if (pattern != null && Util.isSafeToRedirectTo(pattern)) {
            rsp.sendRedirect2(pattern);
            return;
        }
        String path = this.getPath(req);
        if (path.replace('\\', '/').indexOf("/../") != -1) {
            rsp.sendError(400);
            return;
        }
        StringBuilder _base = new StringBuilder();
        StringBuilder _rest = new StringBuilder();
        int restSize = -1;
        boolean zip = false;
        boolean plain = false;
        boolean inBase = true;
        StringTokenizer pathTokens = new StringTokenizer(path, "/");
        while (pathTokens.hasMoreTokens()) {
            StringBuilder sb;
            String pathElement = pathTokens.nextToken();
            if ((pathElement.contains("?") || pathElement.contains("*")) && inBase && !root.child((_base.length() > 0 ? _base + "/" : "") + pathElement).exists()) {
                inBase = false;
            }
            if (pathElement.equals("*zip*")) {
                zip = true;
                break;
            }
            if (pathElement.equals("*plain*")) {
                plain = true;
                break;
            }
            StringBuilder stringBuilder = sb = inBase ? _base : _rest;
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(pathElement);
            if (inBase) continue;
            ++restSize;
        }
        restSize = Math.max(restSize, 0);
        String base = _base.toString();
        String rest = _rest.toString();
        VirtualFile baseFile = root.child(base);
        if (baseFile.isDirectory()) {
            StringBuffer reqUrl;
            if (zip) {
                rsp.setContentType("application/zip");
                DirectoryBrowserSupport.zip((OutputStream)rsp.getOutputStream(), baseFile, rest);
                return;
            }
            if (plain) {
                rsp.setContentType("text/plain;charset=UTF-8");
                try (ServletOutputStream os = rsp.getOutputStream();){
                    for (VirtualFile kid : baseFile.list()) {
                        os.write(kid.getName().getBytes("UTF-8"));
                        if (kid.isDirectory()) {
                            os.write(47);
                        }
                        os.write(10);
                    }
                    os.flush();
                }
                return;
            }
            if (rest.length() == 0 && (reqUrl = req.getRequestURL()).charAt(reqUrl.length() - 1) != '/') {
                rsp.sendRedirect2(reqUrl.append('/').toString());
                return;
            }
            List<List<Path>> glob = null;
            if (rest.length() > 0) {
                glob = DirectoryBrowserSupport.patternScan(baseFile, rest, DirectoryBrowserSupport.createBackRef(restSize));
            } else if (serveDirIndex) {
                glob = baseFile.run(new BuildChildPaths(baseFile, req.getLocale()));
            }
            if (glob != null) {
                req.setAttribute("it", (Object)this);
                List<Path> parentPaths = this.buildParentPath(base, restSize);
                req.setAttribute("parentPath", parentPaths);
                req.setAttribute("backPath", (Object)DirectoryBrowserSupport.createBackRef(restSize));
                req.setAttribute("topPath", (Object)DirectoryBrowserSupport.createBackRef(parentPaths.size() + restSize));
                req.setAttribute("files", glob);
                req.setAttribute("icon", (Object)icon);
                req.setAttribute("path", (Object)path);
                req.setAttribute("pattern", (Object)rest);
                req.setAttribute("dir", (Object)baseFile);
                req.getView((Object)this, "dir.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
                return;
            }
            baseFile = baseFile.child(this.indexFileName);
        }
        if (!baseFile.exists()) {
            rsp.sendError(404);
            return;
        }
        boolean view = rest.equals("*view*");
        if (rest.equals("*fingerprint*")) {
            try (InputStream fingerprintInput = baseFile.open();){
                rsp.forward(Jenkins.getInstance().getFingerprint(Util.getDigestOf(fingerprintInput)), "/", req);
            }
            return;
        }
        long lastModified = baseFile.lastModified();
        long length = baseFile.length();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Serving " + baseFile + " with lastModified=" + lastModified + ", length=" + length);
        }
        InputStream in = baseFile.open();
        if (view) {
            rsp.setHeader("Content-Disposition", "inline; filename=" + baseFile.getName());
            rsp.serveFile(req, in, lastModified, -1L, length, "plain.txt");
        } else {
            String csp = SystemProperties.getString(DirectoryBrowserSupport.class.getName() + ".CSP", DEFAULT_CSP_VALUE);
            if (!csp.trim().equals("")) {
                for (String header : new String[]{"Content-Security-Policy", "X-WebKit-CSP", "X-Content-Security-Policy"}) {
                    rsp.setHeader(header, csp);
                }
            }
            rsp.serveFile(req, in, lastModified, -1L, length, baseFile.getName());
        }
    }

    private String getPath(StaplerRequest req) {
        String path = req.getRestOfPath();
        if (path.length() == 0) {
            path = "/";
        }
        return path;
    }

    private List<Path> buildParentPath(String pathList, int restSize) {
        ArrayList<Path> r = new ArrayList<Path>();
        StringTokenizer tokens = new StringTokenizer(pathList, "/");
        int total = tokens.countTokens();
        int current = 1;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            r.add(new Path(DirectoryBrowserSupport.createBackRef(total - current + restSize), token, true, 0L, true));
            ++current;
        }
        return r;
    }

    private static String createBackRef(int times) {
        if (times == 0) {
            return "./";
        }
        StringBuilder buf = new StringBuilder(3 * times);
        for (int i = 0; i < times; ++i) {
            buf.append("../");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(OutputStream outputStream, VirtualFile dir, String glob) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(outputStream);){
            zos.setEncoding(System.getProperty("file.encoding"));
            for (String n : dir.list(glob.length() == 0 ? "**" : glob)) {
                String relativePath = glob.length() == 0 ? dir.getName() + '/' + n : n;
                ZipEntry e = new ZipEntry(relativePath.replace('\\', '/'));
                VirtualFile f = dir.child(n);
                e.setTime(f.lastModified());
                zos.putNextEntry(e);
                InputStream in = f.open();
                try {
                    Util.copyStream(in, (OutputStream)zos);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
                zos.closeEntry();
            }
        }
    }

    private static List<List<Path>> buildChildPaths(VirtualFile cur, Locale locale) throws IOException {
        ArrayList<List<Path>> r = new ArrayList<List<Path>>();
        VirtualFile[] files = cur.list();
        Arrays.sort(files, new FileComparator(locale));
        for (VirtualFile f : files) {
            Path p = new Path(Util.rawEncode(f.getName()), f.getName(), f.isDirectory(), f.length(), f.canRead());
            if (!f.isDirectory()) {
                r.add(Collections.singletonList(p));
                continue;
            }
            ArrayList<Path> l = new ArrayList<Path>();
            l.add(p);
            String relPath = Util.rawEncode(f.getName());
            while (true) {
                ArrayList<VirtualFile> sub = new ArrayList<VirtualFile>();
                for (VirtualFile vf : f.list()) {
                    String name = vf.getName();
                    if (name.startsWith(".") || name.equals("CVS") || name.equals(".svn")) continue;
                    sub.add(vf);
                }
                if (sub.size() != 1 || !((VirtualFile)sub.get(0)).isDirectory()) break;
                f = (VirtualFile)sub.get(0);
                relPath = relPath + '/' + Util.rawEncode(f.getName());
                l.add(new Path(relPath, f.getName(), true, 0L, f.canRead()));
            }
            r.add(l);
        }
        return r;
    }

    private static List<List<Path>> patternScan(VirtualFile baseDir, String pattern, String baseRef) throws IOException {
        String[] files = baseDir.list(pattern);
        if (files.length > 0) {
            ArrayList<List<Path>> r = new ArrayList<List<Path>>(files.length);
            for (String match : files) {
                List<Path> file = DirectoryBrowserSupport.buildPathList(baseDir, baseDir.child(match), baseRef);
                r.add(file);
            }
            return r;
        }
        return null;
    }

    private static List<Path> buildPathList(VirtualFile baseDir, VirtualFile filePath, String baseRef) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        StringBuilder href = new StringBuilder(baseRef);
        DirectoryBrowserSupport.buildPathList(baseDir, filePath, pathList, href);
        return pathList;
    }

    private static void buildPathList(VirtualFile baseDir, VirtualFile filePath, List<Path> pathList, StringBuilder href) throws IOException {
        VirtualFile parent = filePath.getParent();
        if (!baseDir.equals(parent)) {
            DirectoryBrowserSupport.buildPathList(baseDir, parent, pathList, href);
        }
        href.append(Util.rawEncode(filePath.getName()));
        if (filePath.isDirectory()) {
            href.append("/");
        }
        Path path = new Path(href.toString(), filePath.getName(), filePath.isDirectory(), filePath.length(), filePath.canRead());
        pathList.add(path);
    }

    private static final class BuildChildPaths
    extends MasterToSlaveCallable<List<List<Path>>, IOException> {
        private final VirtualFile cur;
        private final Locale locale;

        BuildChildPaths(VirtualFile cur, Locale locale) {
            this.cur = cur;
            this.locale = locale;
        }

        @Override
        public List<List<Path>> call() throws IOException {
            return DirectoryBrowserSupport.buildChildPaths(this.cur, this.locale);
        }
    }

    private static final class FileComparator
    implements Comparator<VirtualFile> {
        private Collator collator;

        FileComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
        }

        @Override
        public int compare(VirtualFile lhs, VirtualFile rhs) {
            int r = this.dirRank(lhs) - this.dirRank(rhs);
            if (r != 0) {
                return r;
            }
            return this.collator.compare(lhs.getName(), rhs.getName());
        }

        private int dirRank(VirtualFile f) {
            try {
                if (f.isDirectory()) {
                    return 0;
                }
                return 1;
            }
            catch (IOException ex) {
                return 0;
            }
        }
    }

    public static final class Path
    implements Serializable {
        private final String href;
        private final String title;
        private final boolean isFolder;
        private final long size;
        private final boolean isReadable;
        private static final long serialVersionUID = 1L;

        public Path(String href, String title, boolean isFolder, long size, boolean isReadable) {
            this.href = href;
            this.title = title;
            this.isFolder = isFolder;
            this.size = size;
            this.isReadable = isReadable;
        }

        public boolean isFolder() {
            return this.isFolder;
        }

        public boolean isReadable() {
            return this.isReadable;
        }

        public String getHref() {
            return this.href;
        }

        public String getTitle() {
            return this.title;
        }

        public String getIconName() {
            if (this.isReadable) {
                return this.isFolder ? "folder.png" : "text.png";
            }
            return this.isFolder ? "folder-error.png" : "text-error.png";
        }

        public String getIconClassName() {
            if (this.isReadable) {
                return this.isFolder ? "icon-folder" : "icon-text";
            }
            return this.isFolder ? "icon-folder-error" : "icon-text-error";
        }

        public long getSize() {
            return this.size;
        }
    }
}

