/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.lifecycle.Lifecycle;
import hudson.util.StreamTaskListener;
import hudson.util.jna.Kernel32;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class WindowsServiceLifecycle
extends Lifecycle {
    private static final Logger LOGGER = Logger.getLogger(WindowsServiceLifecycle.class.getName());

    public WindowsServiceLifecycle() {
        this.updateJenkinsExeIfNeeded();
    }

    private void updateJenkinsExeIfNeeded() {
        try {
            File rootDir = Jenkins.getInstance().getRootDir();
            URL exe = this.getClass().getResource("/windows-service/jenkins.exe");
            String ourCopy = Util.getDigestOf(exe.openStream());
            for (String name : new String[]{"hudson.exe", "jenkins.exe"}) {
                try {
                    String curCopy;
                    File currentCopy = new File(rootDir, name);
                    if (!currentCopy.exists() || ourCopy.equals(curCopy = new FilePath(currentCopy).digest())) continue;
                    File stage = new File(rootDir, name + ".new");
                    FileUtils.copyURLToFile((URL)exe, (File)stage);
                    Kernel32.INSTANCE.MoveFileExA(stage.getAbsolutePath(), currentCopy.getAbsolutePath(), 5);
                    LOGGER.info("Scheduled a replacement of " + name);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to replace " + name, e);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to replace jenkins.exe", e);
        }
    }

    @Override
    public void rewriteHudsonWar(File by) throws IOException {
        File dest = this.getHudsonWar();
        if (dest == null) {
            throw new IOException("jenkins.war location is not known.");
        }
        File bak = new File(dest.getPath() + ".bak");
        if (!by.equals(bak)) {
            FileUtils.copyFile((File)dest, (File)bak);
        }
        String baseName = dest.getName();
        baseName = baseName.substring(0, baseName.indexOf(46));
        File rootDir = Jenkins.getInstance().getRootDir();
        File copyFiles = new File(rootDir, baseName + ".copies");
        try (FileWriter w = new FileWriter(copyFiles, true);){
            w.write(by.getAbsolutePath() + '>' + this.getHudsonWar().getAbsolutePath() + '\n');
        }
    }

    @Override
    public void restart() throws IOException, InterruptedException {
        int r;
        File me = this.getHudsonWar();
        File home = me.getParentFile();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamTaskListener task = new StreamTaskListener((OutputStream)baos);
        task.getLogger().println("Restarting a service");
        String exe = System.getenv("WINSW_EXECUTABLE");
        File executable = exe != null ? new File(exe) : new File(home, "hudson.exe");
        if (!executable.exists()) {
            executable = new File(home, "jenkins.exe");
        }
        if ((r = new Launcher.LocalLauncher(task).launch().cmds(executable, "restart!").stdout(task).pwd(home).join()) != 0) {
            throw new IOException(baos.toString());
        }
    }
}

