/*
 * Decompiled with CFR 0.152.
 */
package hudson.diagnosis;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.diagnosis.Messages;
import hudson.model.AbstractModelObject;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import java.util.List;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;

@Extension
@Symbol(value={"diskUsageCheck"})
public final class HudsonHomeDiskUsageMonitor
extends AdministrativeMonitor {
    boolean activated;

    public HudsonHomeDiskUsageMonitor() {
        super("hudsonHomeIsFull");
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public String getDisplayName() {
        return Messages.HudsonHomeDiskUsageMonitor_DisplayName();
    }

    public HttpResponse doAct(@QueryParameter String no) throws IOException {
        if (no != null) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return HttpResponses.redirectToDot();
    }

    public List<Solution> getSolutions() {
        return Solution.all();
    }

    public Solution getSolution(String id) {
        for (Solution s : Solution.all()) {
            if (!s.id.equals(id)) continue;
            return s;
        }
        return null;
    }

    public static HudsonHomeDiskUsageMonitor get() {
        return HudsonHomeDiskUsageMonitor.all().get(HudsonHomeDiskUsageMonitor.class);
    }

    public static abstract class Solution
    extends AbstractModelObject
    implements ExtensionPoint {
        public final String id;

        protected Solution(String id) {
            this.id = id;
        }

        protected Solution() {
            this.id = this.getClass().getName();
        }

        public String getUrl() {
            return HudsonHomeDiskUsageMonitor.get().getUrl() + "/solution/" + this.id;
        }

        public static ExtensionList<Solution> all() {
            return ExtensionList.lookup(Solution.class);
        }
    }
}

