/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;

public class HudsonExceptionNote
extends ConsoleNote<Object> {
    private static final String CLASSNAME_PATTERN = "[\\p{L}0-9$_.]+";
    private static final Pattern CLASSNAME = Pattern.compile("[\\p{L}0-9$_.]+\r?\n?");
    private static final Pattern STACK_TRACE_ELEMENT = Pattern.compile("\tat ([\\p{L}0-9$_.]+)\\.([\\p{L}0-9$_<>]+)\\((\\S+):([0-9]+)\\)");
    private static final String CAUSED_BY = "Caused by: ";
    private static final Pattern AND_MORE = Pattern.compile("\t... [0-9]+ more\n");

    @Override
    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        String line = text.getText();
        int end = line.indexOf(58, charPos);
        if (end < 0) {
            if (CLASSNAME.matcher(line.substring(charPos)).matches()) {
                end = line.length();
            } else {
                return null;
            }
        }
        text.addHyperlinkLowKey(charPos, end, this.annotateClassName(line.substring(charPos, end)));
        return new ConsoleAnnotator(){

            public ConsoleAnnotator annotate(Object context, MarkupText text) {
                String line = text.getText();
                Matcher m = STACK_TRACE_ELEMENT.matcher(line);
                if (m.find()) {
                    text.addHyperlinkLowKey(m.start() + 4, m.end(), HudsonExceptionNote.this.annotateMethodName(m.group(1), m.group(2), m.group(3), Integer.parseInt(m.group(4))));
                    return this;
                }
                int idx = line.indexOf(HudsonExceptionNote.CAUSED_BY);
                if (idx >= 0) {
                    int s = idx + HudsonExceptionNote.CAUSED_BY.length();
                    int e = line.indexOf(58, s);
                    if (e < 0) {
                        e = line.length();
                    }
                    text.addHyperlinkLowKey(s, e, HudsonExceptionNote.this.annotateClassName(line.substring(s, e)));
                    return this;
                }
                if (AND_MORE.matcher(line).matches()) {
                    return this;
                }
                return null;
            }
        };
    }

    private String annotateMethodName(String className, String methodName, String sourceFileName, int lineNumber) {
        return "http://stacktrace.jenkins-ci.org/search/?query=" + className + '.' + methodName + "&entity=method";
    }

    private String annotateClassName(String className) {
        return "http://stacktrace.jenkins-ci.org/search?query=" + className;
    }

    @Extension
    @Symbol(value={"stackTrace"})
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        @Override
        public String getDisplayName() {
            return "Exception Stack Trace";
        }
    }
}

