/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.kohsuke.args4j.Argument;

@Extension
public class CopyJobCommand
extends CLICommand {
    @Argument(metaVar="SRC", usage="Name of the job to copy", required=true)
    public TopLevelItem src;
    @Argument(metaVar="DST", usage="Name of the new job to be created.", index=1, required=true)
    public String dst;

    @Override
    public String getShortDescription() {
        return Messages.CopyJobCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        Jenkins jenkins = Jenkins.getActiveInstance();
        if (jenkins.getItemByFullName(this.dst) != null) {
            throw new IllegalStateException("Job '" + this.dst + "' already exists");
        }
        ModifiableTopLevelItemGroup ig = jenkins;
        int i = this.dst.lastIndexOf(47);
        if (i > 0) {
            String group = this.dst.substring(0, i);
            Item item = jenkins.getItemByFullName(group);
            if (item == null) {
                throw new IllegalArgumentException("Unknown ItemGroup " + group);
            }
            if (!(item instanceof ModifiableTopLevelItemGroup)) {
                throw new IllegalStateException("Can't create job from CLI in " + group);
            }
            ig = (ModifiableTopLevelItemGroup)((Object)item);
            this.dst = this.dst.substring(i + 1);
        }
        ig.copy(this.src, this.dst).save();
        return 0;
    }
}

